/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.LinkedList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.batch.infrastructure.item.ItemReader;

public class ListItemReader<T>
implements ItemReader<T> {
    private final List<T> list;

    public ListItemReader(List<T> list) {
        this.list = AopUtils.isAopProxy(list) ? list : new LinkedList<T>(list);
    }

    @Override
    public @Nullable T read() {
        if (!this.list.isEmpty()) {
            return this.list.remove(0);
        }
        return null;
    }
}

