/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.mail;

import java.util.Map;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.batch.infrastructure.item.mail.DefaultMailErrorHandler;
import org.springframework.batch.infrastructure.item.mail.MailErrorHandler;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.util.Assert;

public class SimpleMailMessageItemWriter
implements ItemWriter<SimpleMailMessage> {
    private MailSender mailSender;
    private MailErrorHandler mailErrorHandler = new DefaultMailErrorHandler();

    public SimpleMailMessageItemWriter(MailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"The MailSender must not be null");
        this.mailSender = mailSender;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setMailErrorHandler(MailErrorHandler mailErrorHandler) {
        this.mailErrorHandler = mailErrorHandler;
    }

    @Override
    public void write(Chunk<? extends SimpleMailMessage> chunk) throws MailException {
        try {
            this.mailSender.send(chunk.getItems().toArray(new SimpleMailMessage[chunk.size()]));
        }
        catch (MailSendException e) {
            Map failedMessages = e.getFailedMessages();
            for (Map.Entry entry : failedMessages.entrySet()) {
                this.mailErrorHandler.handle((MailMessage)((SimpleMailMessage)entry.getKey()), (Exception)entry.getValue());
            }
        }
    }
}

