/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.orm;

import jakarta.persistence.Query;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.orm.AbstractJpaQueryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaNativeQueryProvider<E>
extends AbstractJpaQueryProvider {
    private @Nullable Class<E> entityClass;
    private @Nullable String sqlQuery;

    @Override
    public Query createQuery() {
        return this.getEntityManager().createNativeQuery(this.sqlQuery, this.entityClass);
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public void setEntityClass(Class<E> entityClazz) {
        this.entityClass = entityClazz;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state((boolean)StringUtils.hasText((String)this.sqlQuery), (String)"Native SQL query cannot be empty");
        Assert.state((this.entityClass != null ? 1 : 0) != 0, (String)"Entity class cannot be NULL");
    }
}

