/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.data.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.data.MongoPagingItemReader;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoPagingItemReaderBuilder<T> {
    protected @Nullable MongoOperations template;
    protected @Nullable String jsonQuery;
    protected @Nullable Class<? extends T> targetType;
    protected @Nullable Map<String, // Could not load outer class - annotation placement on inner may be incorrect
    Sort.Direction> sorts;
    protected @Nullable String hint;
    protected @Nullable String fields;
    protected @Nullable String collection;
    protected List<Object> parameterValues = new ArrayList<Object>();
    protected int pageSize = 10;
    protected boolean saveState = true;
    protected @Nullable String name;
    protected int maxItemCount = Integer.MAX_VALUE;
    protected int currentItemCount;
    protected @Nullable Query query;

    public MongoPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> jsonQuery(String query) {
        this.jsonQuery = query;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> targetType(Class<? extends T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> parameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> parameterValues(Object ... parameterValues) {
        return this.parameterValues(Arrays.asList(parameterValues));
    }

    public MongoPagingItemReaderBuilder<T> fields(String fields) {
        this.fields = fields;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MongoPagingItemReaderBuilder<T> query(Query query) {
        this.query = query;
        return this;
    }

    public MongoPagingItemReader<T> build() {
        Assert.notNull((Object)this.template, (String)"template is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        Assert.notNull(this.targetType, (String)"targetType is required.");
        Assert.state((StringUtils.hasText((String)this.jsonQuery) || this.query != null ? 1 : 0) != 0, (String)"A query is required");
        if (StringUtils.hasText((String)this.jsonQuery) || this.query != null) {
            Assert.notNull(this.sorts, (String)"sorts map is required.");
        }
        MongoPagingItemReader<? extends T> reader = new MongoPagingItemReader<T>(this.template, this.targetType);
        reader.setTemplate(this.template);
        reader.setTargetType(this.targetType);
        if (StringUtils.hasText((String)this.jsonQuery)) {
            reader.setQuery(this.jsonQuery);
        }
        if (this.sorts != null) {
            reader.setSort(this.sorts);
        }
        if (this.hint != null) {
            reader.setHint(this.hint);
        }
        if (this.fields != null) {
            reader.setFields(this.fields);
        }
        if (this.collection != null) {
            reader.setCollection(this.collection);
        }
        reader.setParameterValues(this.parameterValues);
        if (this.query != null) {
            reader.setQuery(this.query);
        }
        reader.setPageSize(this.pageSize);
        if (this.name != null) {
            reader.setName(this.name);
        }
        reader.setSaveState(this.saveState);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        return reader;
    }
}

