/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.support;

import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public enum DatabaseType {
    DERBY("Apache Derby"),
    DB2("DB2"),
    DB2VSE("DB2VSE"),
    DB2ZOS("DB2ZOS"),
    DB2AS400("DB2AS400"),
    HSQL("HSQL Database Engine"),
    SQLSERVER("Microsoft SQL Server"),
    MYSQL("MySQL"),
    ORACLE("Oracle"),
    POSTGRES("PostgreSQL"),
    SYBASE("Sybase"),
    H2("H2"),
    SQLITE("SQLite"),
    HANA("HDB"),
    MARIADB("MariaDB");

    private static final Map<String, DatabaseType> DATABASE_TYPES;
    private final String productName;

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public static DatabaseType fromProductName(String productName) {
        Assert.notNull((Object)productName, (String)"Product name must not be null");
        if (!DATABASE_TYPES.containsKey(productName)) {
            throw new IllegalArgumentException("DatabaseType not found for product name: [" + productName + "]");
        }
        return DATABASE_TYPES.get(productName);
    }

    public static DatabaseType fromMetaData(DataSource dataSource) throws MetaDataAccessException {
        String databaseProductName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
        if (StringUtils.hasText((String)databaseProductName) && databaseProductName.startsWith("DB2")) {
            String databaseProductVersion = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductVersion);
            if (!StringUtils.hasText((String)databaseProductVersion)) {
                throw new MetaDataAccessException("Database product version not found for " + databaseProductName);
            }
            databaseProductName = databaseProductVersion.startsWith("ARI") ? "DB2VSE" : (databaseProductVersion.startsWith("DSN") ? "DB2ZOS" : (databaseProductName.contains("AS") && (databaseProductVersion.startsWith("QSQ") || databaseProductVersion.substring(databaseProductVersion.indexOf(86)).matches("V\\dR\\d[mM]\\d")) ? "DB2AS400" : JdbcUtils.commonDatabaseName((String)databaseProductName)));
        } else {
            databaseProductName = StringUtils.hasText((String)databaseProductName) && databaseProductName.startsWith("EnterpriseDB") ? "PostgreSQL" : JdbcUtils.commonDatabaseName((String)databaseProductName);
        }
        if (!StringUtils.hasText((String)databaseProductName)) {
            throw new MetaDataAccessException("Database product name not found for data source " + String.valueOf(dataSource));
        }
        return DatabaseType.fromProductName(databaseProductName);
    }

    static {
        DATABASE_TYPES = Arrays.stream(DatabaseType.values()).collect(Collectors.toMap(DatabaseType::getProductName, Function.identity()));
    }
}

