/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.policy;

import org.springframework.batch.infrastructure.repeat.RepeatContext;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;
import org.springframework.batch.infrastructure.repeat.context.RepeatContextSupport;
import org.springframework.batch.infrastructure.repeat.policy.DefaultResultCompletionPolicy;
import org.springframework.util.ClassUtils;

public class SimpleCompletionPolicy
extends DefaultResultCompletionPolicy {
    public static final int DEFAULT_CHUNK_SIZE = 5;
    int chunkSize = 0;

    public SimpleCompletionPolicy() {
        this(5);
    }

    public SimpleCompletionPolicy(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public RepeatContext start(RepeatContext context) {
        return new SimpleTerminationContext(context);
    }

    @Override
    public boolean isComplete(RepeatContext context, RepeatStatus result) {
        return super.isComplete(context, result) || ((SimpleTerminationContext)context).isComplete();
    }

    @Override
    public boolean isComplete(RepeatContext context) {
        return ((SimpleTerminationContext)context).isComplete();
    }

    @Override
    public void update(RepeatContext context) {
        ((SimpleTerminationContext)context).update();
    }

    public String toString() {
        return ClassUtils.getShortName(SimpleCompletionPolicy.class) + ": chunkSize=" + this.chunkSize;
    }

    protected class SimpleTerminationContext
    extends RepeatContextSupport {
        public SimpleTerminationContext(RepeatContext context) {
            super(context);
        }

        public void update() {
            this.increment();
        }

        public boolean isComplete() {
            return this.getStartedCount() >= SimpleCompletionPolicy.this.chunkSize;
        }
    }
}

