/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.ItemStreamWriter;
import org.springframework.util.Assert;

public class SynchronizedItemStreamWriter<T>
implements ItemStreamWriter<T> {
    private ItemStreamWriter<T> delegate;
    private final Lock lock = new ReentrantLock();

    public SynchronizedItemStreamWriter(ItemStreamWriter<T> delegate) {
        Assert.notNull(delegate, (String)"The delegate item writer must not be null");
        this.delegate = delegate;
    }

    public void setDelegate(ItemStreamWriter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        this.lock.lock();
        try {
            this.delegate.write(items);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.open(executionContext);
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.update(executionContext);
    }

    @Override
    public void close() throws ItemStreamException {
        this.delegate.close();
    }
}

