/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.json;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.infrastructure.item.json.JsonObjectReader;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class JsonItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T> {
    private static final Log LOGGER = LogFactory.getLog(JsonItemReader.class);
    private Resource resource;
    private JsonObjectReader<T> jsonObjectReader;
    private boolean strict = true;

    public JsonItemReader(Resource resource, JsonObjectReader<T> jsonObjectReader) {
        Assert.notNull((Object)resource, (String)"The resource must not be null.");
        Assert.notNull(jsonObjectReader, (String)"The json object reader must not be null.");
        this.resource = resource;
        this.jsonObjectReader = jsonObjectReader;
    }

    public void setJsonObjectReader(JsonObjectReader<T> jsonObjectReader) {
        this.jsonObjectReader = jsonObjectReader;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    protected @Nullable T doRead() throws Exception {
        return this.jsonObjectReader.read();
    }

    @Override
    protected void doOpen() throws Exception {
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode)");
            }
            LOGGER.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode)");
            }
            LOGGER.warn((Object)("Input resource is not readable " + this.resource.getDescription()));
            return;
        }
        this.jsonObjectReader.open(this.resource);
    }

    @Override
    protected void doClose() throws Exception {
        this.jsonObjectReader.close();
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        this.jsonObjectReader.jumpToItem(itemIndex);
    }
}

