/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ReaderNotOpenException;
import org.springframework.batch.infrastructure.item.file.BufferedReaderFactory;
import org.springframework.batch.infrastructure.item.file.DefaultBufferedReaderFactory;
import org.springframework.batch.infrastructure.item.file.FlatFileParseException;
import org.springframework.batch.infrastructure.item.file.LineCallbackHandler;
import org.springframework.batch.infrastructure.item.file.LineMapper;
import org.springframework.batch.infrastructure.item.file.NonTransientFlatFileException;
import org.springframework.batch.infrastructure.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.infrastructure.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.infrastructure.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FlatFileItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T> {
    private static final Log logger = LogFactory.getLog(FlatFileItemReader.class);
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    public static final String[] DEFAULT_COMMENT_PREFIXES = new String[]{"#"};
    private RecordSeparatorPolicy recordSeparatorPolicy = new SimpleRecordSeparatorPolicy();
    private @Nullable Resource resource;
    private @Nullable BufferedReader reader;
    private int lineCount = 0;
    protected String[] comments = DEFAULT_COMMENT_PREFIXES;
    private boolean noInput = false;
    private String encoding = DEFAULT_CHARSET;
    private LineMapper<T> lineMapper;
    private int linesToSkip = 0;
    private @Nullable LineCallbackHandler skippedLinesCallback;
    private boolean strict = true;
    private BufferedReaderFactory bufferedReaderFactory = new DefaultBufferedReaderFactory();

    public FlatFileItemReader(LineMapper<T> lineMapper) {
        Assert.notNull(lineMapper, (String)"A LineMapper is required");
        this.lineMapper = lineMapper;
    }

    public FlatFileItemReader(Resource resource, LineMapper<T> lineMapper) {
        this(lineMapper);
        Assert.notNull((Object)resource, (String)"The resource must not be null");
        this.resource = resource;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSkippedLinesCallback(LineCallbackHandler skippedLinesCallback) {
        this.skippedLinesCallback = skippedLinesCallback;
    }

    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    public void setLineMapper(LineMapper<T> lineMapper) {
        this.lineMapper = lineMapper;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setBufferedReaderFactory(BufferedReaderFactory bufferedReaderFactory) {
        this.bufferedReaderFactory = bufferedReaderFactory;
    }

    public void setComments(String[] comments) {
        this.comments = new String[comments.length];
        System.arraycopy(comments, 0, this.comments, 0, comments.length);
    }

    @Override
    public void setResource(@Nullable Resource resource) {
        this.resource = resource;
    }

    public void setRecordSeparatorPolicy(RecordSeparatorPolicy recordSeparatorPolicy) {
        this.recordSeparatorPolicy = recordSeparatorPolicy;
    }

    @Override
    protected @Nullable T doRead() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        if (this.noInput) {
            return null;
        }
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        try {
            return this.lineMapper.mapLine(line, this.lineCount);
        }
        catch (Exception ex) {
            throw new FlatFileParseException("Parsing error at line: " + this.lineCount + " in resource=[" + this.resource.getDescription() + "], input=[" + line + "]", (Throwable)ex, line, this.lineCount);
        }
    }

    private @Nullable String readLine() {
        if (this.reader == null) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        String line = null;
        try {
            do {
                if ((line = this.reader.readLine()) == null) {
                    return null;
                }
                ++this.lineCount;
            } while (this.isComment(line));
            line = this.applyRecordSeparatorPolicy(line);
        }
        catch (IOException e) {
            this.noInput = true;
            if (line == null) {
                throw new NonTransientFlatFileException("Unable to read from resource: [" + String.valueOf(this.resource) + "]", e);
            }
            throw new NonTransientFlatFileException("Unable to read from resource: [" + String.valueOf(this.resource) + "]", (Throwable)e, line, this.lineCount);
        }
        return line;
    }

    protected boolean isComment(String line) {
        for (String prefix : this.comments) {
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doClose() throws Exception {
        this.lineCount = 0;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + String.valueOf(this.resource));
            }
            logger.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode): " + String.valueOf(this.resource));
            }
            logger.warn((Object)("Input resource is not readable " + this.resource.getDescription()));
            return;
        }
        this.reader = this.bufferedReaderFactory.create(this.resource, this.encoding);
        for (int i = 0; i < this.linesToSkip; ++i) {
            String line = this.readLine();
            if (this.skippedLinesCallback == null || line == null) continue;
            this.skippedLinesCallback.handleLine(line);
        }
        this.noInput = false;
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            this.readLine();
        }
    }

    private String applyRecordSeparatorPolicy(String line) throws IOException {
        if (this.reader == null) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        Object record = line;
        while (!this.recordSeparatorPolicy.isEndOfRecord((String)record)) {
            line = this.reader.readLine();
            if (line == null) {
                if (!StringUtils.hasText((String)record)) break;
                throw new FlatFileParseException("Unexpected end of file before record complete", (String)record, this.lineCount);
            }
            ++this.lineCount;
            record = this.recordSeparatorPolicy.preProcess((String)record) + line;
        }
        return this.recordSeparatorPolicy.postProcess((String)record);
    }
}

