/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.item.WriterNotOpenException;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.support.AbstractItemStreamItemWriter;
import org.springframework.batch.item.util.FileUtils;
import org.springframework.batch.item.xml.StaxWriterCallback;
import org.springframework.batch.item.xml.stax.NoStartEndDocumentStreamWriter;
import org.springframework.batch.item.xml.stax.UnclosedElementCollectingEventWriter;
import org.springframework.batch.item.xml.stax.UnopenedElementClosingEventWriter;
import org.springframework.batch.support.transaction.TransactionAwareBufferedWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.WritableResource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;

public class StaxEventItemWriter<T>
extends AbstractItemStreamItemWriter<T>
implements ResourceAwareItemWriterItemStream<T>,
InitializingBean {
    private static final Log log = LogFactory.getLog(StaxEventItemWriter.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_XML_VERSION = "1.0";
    public static final Boolean DEFAULT_STANDALONE_DOCUMENT = null;
    public static final String DEFAULT_ROOT_TAG_NAME = "root";
    private static final String RESTART_DATA_NAME = "position";
    private static final String UNCLOSED_HEADER_CALLBACK_ELEMENTS_NAME = "unclosedHeaderCallbackElements";
    private static final String WRITE_STATISTICS_NAME = "record.count";
    private WritableResource resource;
    private Marshaller marshaller;
    private String encoding = "UTF-8";
    private String version = "1.0";
    private Boolean standalone = DEFAULT_STANDALONE_DOCUMENT;
    private String rootTagName = "root";
    private String rootTagNamespacePrefix = "";
    private String rootTagNamespace = "";
    private Map<String, String> rootElementAttributes = null;
    private boolean overwriteOutput = true;
    private FileChannel channel;
    private XMLEventWriter eventWriter;
    private XMLEventWriter delegateEventWriter;
    private long currentRecordCount = 0L;
    private boolean saveState = true;
    private StaxWriterCallback headerCallback;
    private StaxWriterCallback footerCallback;
    private Writer bufferedWriter;
    private boolean transactional = true;
    private boolean forceSync;
    private boolean shouldDeleteIfEmpty = false;
    private boolean restarted = false;
    private boolean initialized = false;
    private List<QName> unclosedHeaderCallbackElements = Collections.emptyList();

    public StaxEventItemWriter() {
        this.setExecutionContextName(ClassUtils.getShortName(StaxEventItemWriter.class));
    }

    @Override
    public void setResource(WritableResource resource) {
        this.resource = resource;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setHeaderCallback(StaxWriterCallback headerCallback) {
        this.headerCallback = headerCallback;
    }

    public void setFooterCallback(StaxWriterCallback footerCallback) {
        this.footerCallback = footerCallback;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public void setShouldDeleteIfEmpty(boolean shouldDeleteIfEmpty) {
        this.shouldDeleteIfEmpty = shouldDeleteIfEmpty;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public String getRootTagName() {
        return this.rootTagName;
    }

    public void setRootTagName(String rootTagName) {
        this.rootTagName = rootTagName;
    }

    public String getRootTagNamespacePrefix() {
        return this.rootTagNamespacePrefix;
    }

    public String getRootTagNamespace() {
        return this.rootTagNamespace;
    }

    public Map<String, String> getRootElementAttributes() {
        return this.rootElementAttributes;
    }

    public void setRootElementAttributes(Map<String, String> rootElementAttributes) {
        this.rootElementAttributes = rootElementAttributes;
    }

    public void setOverwriteOutput(boolean overwriteOutput) {
        this.overwriteOutput = overwriteOutput;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.marshaller != null ? 1 : 0) != 0, (String)"A Marshaller is required");
        if (this.rootTagName.contains("{")) {
            this.rootTagNamespace = this.rootTagName.replaceAll("\\{(.*)\\}.*", "$1");
            this.rootTagName = this.rootTagName.replaceAll("\\{.*\\}(.*)", "$1");
            if (this.rootTagName.contains(":")) {
                this.rootTagNamespacePrefix = this.rootTagName.replaceAll("(.*):.*", "$1");
                this.rootTagName = this.rootTagName.replaceAll(".*:(.*)", "$1");
            }
        }
    }

    @Override
    public void open(ExecutionContext executionContext) {
        super.open(executionContext);
        Assert.notNull((Object)this.resource, (String)"The resource must be set");
        long startAtPosition = 0L;
        if (executionContext.containsKey(this.getExecutionContextKey(RESTART_DATA_NAME))) {
            startAtPosition = executionContext.getLong(this.getExecutionContextKey(RESTART_DATA_NAME));
            this.currentRecordCount = executionContext.getLong(this.getExecutionContextKey(WRITE_STATISTICS_NAME));
            if (executionContext.containsKey(this.getExecutionContextKey(UNCLOSED_HEADER_CALLBACK_ELEMENTS_NAME))) {
                this.unclosedHeaderCallbackElements = (List)executionContext.get(this.getExecutionContextKey(UNCLOSED_HEADER_CALLBACK_ELEMENTS_NAME));
            }
            this.restarted = true;
            if (this.shouldDeleteIfEmpty && this.currentRecordCount == 0L) {
                this.restarted = false;
                startAtPosition = 0L;
            } else {
                this.restarted = true;
            }
        } else {
            this.currentRecordCount = 0L;
            this.restarted = false;
        }
        this.open(startAtPosition);
        if (startAtPosition == 0L) {
            try {
                if (this.headerCallback != null) {
                    UnclosedElementCollectingEventWriter headerCallbackWriter = new UnclosedElementCollectingEventWriter(this.delegateEventWriter);
                    this.headerCallback.write(headerCallbackWriter);
                    this.unclosedHeaderCallbackElements = headerCallbackWriter.getUnclosedElements();
                }
            }
            catch (IOException e) {
                throw new ItemStreamException("Failed to write headerItems", e);
            }
        }
        this.initialized = true;
    }

    private void open(long position) {
        FileChannel fileChannel;
        FileOutputStream os;
        try {
            File file = this.resource.getFile();
            FileUtils.setUpOutputFile(file, this.restarted, false, this.overwriteOutput);
            Assert.state((boolean)this.resource.exists(), (String)"Output resource must exist");
            os = new FileOutputStream(file, true);
            fileChannel = os.getChannel();
            this.channel = os.getChannel();
            this.setPosition(position);
        }
        catch (IOException ioe) {
            throw new ItemStreamException("Unable to write to file resource: [" + String.valueOf(this.resource) + "]", ioe);
        }
        XMLOutputFactory outputFactory = this.createXmlOutputFactory();
        if (outputFactory.isPropertySupported("com.ctc.wstx.automaticEndElements")) {
            outputFactory.setProperty("com.ctc.wstx.automaticEndElements", Boolean.FALSE);
        }
        if (outputFactory.isPropertySupported("com.ctc.wstx.outputValidateStructure")) {
            outputFactory.setProperty("com.ctc.wstx.outputValidateStructure", Boolean.FALSE);
        }
        try {
            if (this.transactional) {
                TransactionAwareBufferedWriter writer = new TransactionAwareBufferedWriter(fileChannel, this::closeStream);
                writer.setEncoding(this.encoding);
                writer.setForceSync(this.forceSync);
                this.bufferedWriter = writer;
            } else {
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)os, this.encoding));
            }
            this.delegateEventWriter = this.createXmlEventWriter(outputFactory, this.bufferedWriter);
            this.eventWriter = new NoStartEndDocumentStreamWriter(this.delegateEventWriter);
            this.initNamespaceContext(this.delegateEventWriter);
            if (!this.restarted) {
                this.startDocument(this.delegateEventWriter);
                if (this.forceSync) {
                    fileChannel.force(false);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ItemStreamException("Unable to write to file resource: [" + String.valueOf(this.resource) + "] with encoding=[" + this.encoding + "]", e);
        }
        catch (IOException | XMLStreamException xse) {
            throw new ItemStreamException("Unable to write to file resource: [" + String.valueOf(this.resource) + "]", xse);
        }
    }

    protected XMLEventWriter createXmlEventWriter(XMLOutputFactory outputFactory, Writer writer) throws XMLStreamException {
        return outputFactory.createXMLEventWriter(writer);
    }

    protected XMLOutputFactory createXmlOutputFactory() throws FactoryConfigurationError {
        return XMLOutputFactory.newInstance();
    }

    protected XMLEventFactory createXmlEventFactory() throws FactoryConfigurationError {
        return XMLEventFactory.newInstance();
    }

    protected Result createStaxResult() {
        return StaxUtils.createStaxResult((XMLEventWriter)this.eventWriter);
    }

    protected void initNamespaceContext(XMLEventWriter writer) throws XMLStreamException {
        if (StringUtils.hasText((String)this.getRootTagNamespace())) {
            if (StringUtils.hasText((String)this.getRootTagNamespacePrefix())) {
                writer.setPrefix(this.getRootTagNamespacePrefix(), this.getRootTagNamespace());
            } else {
                writer.setDefaultNamespace(this.getRootTagNamespace());
            }
        }
        if (!CollectionUtils.isEmpty(this.getRootElementAttributes())) {
            for (Map.Entry<String, String> entry : this.getRootElementAttributes().entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith("xmlns")) continue;
                String prefix = "";
                if (key.contains(":")) {
                    prefix = key.substring(key.indexOf(":") + 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("registering prefix: " + prefix + "=" + entry.getValue()));
                }
                writer.setPrefix(prefix, entry.getValue());
            }
        }
    }

    protected void startDocument(XMLEventWriter writer) throws XMLStreamException {
        XMLEventFactory factory = this.createXmlEventFactory();
        if (this.getStandalone() == null) {
            writer.add(factory.createStartDocument(this.getEncoding(), this.getVersion()));
        } else {
            writer.add(factory.createStartDocument(this.getEncoding(), this.getVersion(), this.getStandalone()));
        }
        writer.add(factory.createStartElement(this.getRootTagNamespacePrefix(), this.getRootTagNamespace(), this.getRootTagName()));
        if (StringUtils.hasText((String)this.getRootTagNamespace())) {
            if (StringUtils.hasText((String)this.getRootTagNamespacePrefix())) {
                writer.add(factory.createNamespace(this.getRootTagNamespacePrefix(), this.getRootTagNamespace()));
            } else {
                writer.add(factory.createNamespace(this.getRootTagNamespace()));
            }
        }
        if (!CollectionUtils.isEmpty(this.getRootElementAttributes())) {
            for (Map.Entry<String, String> entry : this.getRootElementAttributes().entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("xmlns")) {
                    String prefix = "";
                    if (key.contains(":")) {
                        prefix = key.substring(key.indexOf(":") + 1);
                    }
                    writer.add(factory.createNamespace(prefix, entry.getValue()));
                    continue;
                }
                writer.add(factory.createAttribute(key, entry.getValue()));
            }
        }
        writer.add(factory.createIgnorableSpace(""));
        writer.flush();
    }

    protected void endDocument(XMLEventWriter writer) throws XMLStreamException {
        String nsPrefix = !StringUtils.hasText((String)this.getRootTagNamespacePrefix()) ? "" : this.getRootTagNamespacePrefix() + ":";
        try {
            this.bufferedWriter.write("</" + nsPrefix + this.getRootTagName() + ">");
        }
        catch (IOException ioe) {
            throw new XMLStreamException("Unable to close file resource: [" + String.valueOf(this.resource) + "]", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        super.close();
        XMLEventFactory factory = this.createXmlEventFactory();
        try {
            this.delegateEventWriter.add(factory.createCharacters(""));
        }
        catch (XMLStreamException e) {
            log.error((Object)e);
        }
        try {
            if (this.footerCallback != null) {
                XMLEventWriter footerCallbackWriter = this.delegateEventWriter;
                if (this.restarted && !this.unclosedHeaderCallbackElements.isEmpty()) {
                    footerCallbackWriter = new UnopenedElementClosingEventWriter(this.delegateEventWriter, this.bufferedWriter, this.unclosedHeaderCallbackElements);
                }
                this.footerCallback.write(footerCallbackWriter);
            }
            this.delegateEventWriter.flush();
            this.endDocument(this.delegateEventWriter);
        }
        catch (IOException e) {
            throw new ItemStreamException("Failed to write footer items", e);
        }
        catch (XMLStreamException e) {
            throw new ItemStreamException("Failed to write end document tag", e);
        }
        finally {
            try {
                this.delegateEventWriter.close();
            }
            catch (XMLStreamException e) {
                log.error((Object)("Unable to close file resource: [" + String.valueOf(this.resource) + "] " + String.valueOf(e)));
            }
            finally {
                try {
                    this.bufferedWriter.close();
                }
                catch (IOException e) {
                    log.error((Object)("Unable to close file resource: [" + String.valueOf(this.resource) + "] " + String.valueOf(e)));
                }
                finally {
                    if (!this.transactional) {
                        this.closeStream();
                    }
                }
            }
            if (this.currentRecordCount == 0L && this.shouldDeleteIfEmpty) {
                try {
                    Files.delete(this.resource.getFile().toPath());
                }
                catch (IOException | SecurityException e) {
                    throw new ItemStreamException("Failed to delete empty file on close", e);
                }
            }
        }
        this.initialized = false;
    }

    private void closeStream() {
        try {
            this.channel.close();
        }
        catch (IOException ioe) {
            log.error((Object)("Unable to close file resource: [" + String.valueOf(this.resource) + "] " + String.valueOf(ioe)));
        }
    }

    @Override
    public void write(Chunk<? extends T> items) throws XmlMappingException, IOException {
        if (!this.initialized) {
            throw new WriterNotOpenException("Writer must be open before it can be written to");
        }
        this.currentRecordCount += (long)items.size();
        for (Object object : items) {
            Assert.state((boolean)this.marshaller.supports(object.getClass()), (String)"Marshaller must support the class of the marshalled object");
            Result result = this.createStaxResult();
            this.marshaller.marshal(object, result);
        }
        try {
            this.eventWriter.flush();
            if (this.forceSync) {
                this.channel.force(false);
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new WriteFailedException("Failed to flush the events", e);
        }
    }

    @Override
    public void update(ExecutionContext executionContext) {
        super.update(executionContext);
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(this.getExecutionContextKey(RESTART_DATA_NAME), this.getPosition());
            executionContext.putLong(this.getExecutionContextKey(WRITE_STATISTICS_NAME), this.currentRecordCount);
            if (!this.unclosedHeaderCallbackElements.isEmpty()) {
                executionContext.put(this.getExecutionContextKey(UNCLOSED_HEADER_CALLBACK_ELEMENTS_NAME), this.unclosedHeaderCallbackElements);
            }
        }
    }

    private long getPosition() {
        long position;
        try {
            this.eventWriter.flush();
            position = this.channel.position();
            Writer writer = this.bufferedWriter;
            if (writer instanceof TransactionAwareBufferedWriter) {
                TransactionAwareBufferedWriter transactionAwareBufferedWriter = (TransactionAwareBufferedWriter)writer;
                position += transactionAwareBufferedWriter.getBufferSize();
            }
        }
        catch (Exception e) {
            throw new ItemStreamException("Unable to write to file resource: [" + String.valueOf(this.resource) + "]", e);
        }
        return position;
    }

    private void setPosition(long newPosition) {
        try {
            this.channel.truncate(newPosition);
            this.channel.position(newPosition);
        }
        catch (IOException e) {
            throw new ItemStreamException("Unable to write to file resource: [" + String.valueOf(this.resource) + "]", e);
        }
    }
}

