/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.function;

import java.util.function.Predicate;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.util.Assert;

public class PredicateFilteringItemProcessor<T>
implements ItemProcessor<T, T> {
    private final Predicate<T> predicate;

    public PredicateFilteringItemProcessor(Predicate<T> predicate) {
        Assert.notNull(predicate, (String)"A predicate is required");
        this.predicate = predicate;
    }

    @Override
    public T process(T item) throws Exception {
        return this.predicate.test(item) ? null : (T)item;
    }
}

