/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.kafka.builder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.batch.item.kafka.KafkaItemReader;
import org.springframework.util.Assert;

public class KafkaItemReaderBuilder<K, V> {
    private Properties consumerProperties;
    private String topic;
    private List<Integer> partitions = new ArrayList<Integer>();
    private Duration pollTimeout = Duration.ofSeconds(30L);
    private boolean saveState = true;
    private String name;

    public KafkaItemReaderBuilder<K, V> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> name(String name) {
        this.name = name;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> consumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> partitions(Integer ... partitions) {
        return this.partitions(Arrays.asList(partitions));
    }

    public KafkaItemReaderBuilder<K, V> partitions(List<Integer> partitions) {
        this.partitions = partitions;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> topic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaItemReaderBuilder<K, V> pollTimeout(Duration pollTimeout) {
        this.pollTimeout = pollTimeout;
        return this;
    }

    public KafkaItemReader<K, V> build() {
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        Assert.notNull((Object)this.consumerProperties, (String)"Consumer properties must not be null");
        Assert.isTrue((boolean)this.consumerProperties.containsKey("bootstrap.servers"), (String)"bootstrap.servers property must be provided");
        Assert.isTrue((boolean)this.consumerProperties.containsKey("group.id"), (String)"group.id property must be provided");
        Assert.isTrue((boolean)this.consumerProperties.containsKey("key.deserializer"), (String)"key.deserializer property must be provided");
        Assert.isTrue((boolean)this.consumerProperties.containsKey("value.deserializer"), (String)"value.deserializer property must be provided");
        Assert.hasLength((String)this.topic, (String)"Topic name must not be null or empty");
        Assert.notNull((Object)this.pollTimeout, (String)"pollTimeout must not be null");
        Assert.isTrue((!this.pollTimeout.isZero() ? 1 : 0) != 0, (String)"pollTimeout must not be zero");
        Assert.isTrue((!this.pollTimeout.isNegative() ? 1 : 0) != 0, (String)"pollTimeout must not be negative");
        Assert.isTrue((!this.partitions.isEmpty() ? 1 : 0) != 0, (String)"At least one partition must be provided");
        KafkaItemReader reader = new KafkaItemReader(this.consumerProperties, this.topic, this.partitions);
        reader.setPollTimeout(this.pollTimeout);
        reader.setSaveState(this.saveState);
        reader.setName(this.name);
        return reader;
    }
}

