/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class IbatisPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private SqlMapClient sqlMapClient;
    private String queryId;
    private SqlMapClientTemplate sqlMapClientTemplate;
    private Map<String, Object> parameterValues;

    public IbatisPagingItemReader() {
        this.setName(ClassUtils.getShortName(IbatisPagingItemReader.class));
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.sqlMapClient);
        this.sqlMapClientTemplate = new SqlMapClientTemplate(this.sqlMapClient);
        Assert.notNull((Object)this.queryId);
    }

    @Override
    protected void doReadPage() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.parameterValues != null) {
            parameters.putAll(this.parameterValues);
        }
        parameters.put("_page", this.getPage());
        parameters.put("_pagesize", this.getPageSize());
        parameters.put("_skiprows", this.getPage() * this.getPageSize());
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        this.results.addAll(this.sqlMapClientTemplate.queryForList(this.queryId, parameters));
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }
}

