/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public final class PropertiesConverter {
    private static final PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    private PropertiesConverter() {
    }

    public static Properties stringToProperties(String stringToParse) {
        if (stringToParse == null) {
            return new Properties();
        }
        if (!PropertiesConverter.contains(stringToParse, "\n")) {
            return StringUtils.splitArrayElementsIntoProperties((String[])StringUtils.commaDelimitedListToStringArray((String)stringToParse), (String)"=");
        }
        StringReader stringReader = new StringReader(stringToParse);
        Properties properties = new Properties();
        try {
            propertiesPersister.load(properties, (Reader)stringReader);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while trying to parse String to java.util.Properties, given String: " + properties);
        }
        return properties;
    }

    public static String propertiesToString(Properties propertiesToParse) {
        if (propertiesToParse == null || propertiesToParse.size() == 0) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            propertiesPersister.store(propertiesToParse, (Writer)stringWriter, null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while trying to convert properties to string");
        }
        return stringWriter.toString();
    }

    private static boolean contains(String str, String searchStr) {
        return str.indexOf(searchStr) != -1;
    }
}

