/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.ClassUtils;

public class DefaultPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private Map customEditors;

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (this.customEditors != null) {
            Iterator it = this.customEditors.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Class key = (Class)entry.getKey();
                PropertyEditor value = (PropertyEditor)entry.getValue();
                registry.registerCustomEditor(key, value);
            }
        }
    }

    public void setCustomEditors(Map customEditors) {
        this.customEditors = new HashMap();
        Iterator it = customEditors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Class requiredType = null;
            if (key instanceof Class) {
                requiredType = (Class)key;
            } else if (key instanceof String) {
                String className = (String)key;
                requiredType = ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClass().getClassLoader());
            } else {
                throw new IllegalArgumentException("Invalid key [" + key + "] for custom editor: needs to be Class or String.");
            }
            Object value = entry.getValue();
            if (!(value instanceof PropertyEditor)) {
                throw new IllegalArgumentException("Mapped value [" + value + "] for custom editor key [" + key + "] is not of required type [" + PropertyEditor.class.getName() + "]");
            }
            this.customEditors.put(requiredType, value);
        }
    }
}

