/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.AbstractStatelessRetryPolicy;
import org.springframework.batch.support.BinaryExceptionClassifier;

public class SimpleRetryPolicy
extends AbstractStatelessRetryPolicy {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private volatile int maxAttempts;
    private BinaryExceptionClassifier retryableClassifier = new BinaryExceptionClassifier();
    private BinaryExceptionClassifier fatalClassifier = new BinaryExceptionClassifier();

    public SimpleRetryPolicy() {
        this(3);
    }

    public SimpleRetryPolicy(int maxAttempts) {
        this.setRetryableExceptionClasses(new Class[]{Exception.class});
        this.setFatalExceptionClasses(new Class[]{Error.class});
        this.maxAttempts = maxAttempts;
    }

    public void setMaxAttempts(int retryAttempts) {
        this.maxAttempts = retryAttempts;
    }

    public boolean canRetry(RetryContext context) {
        SimpleRetryContext simpleContext = (SimpleRetryContext)context;
        Throwable t = simpleContext.getLastThrowable();
        return (t == null || this.retryForException(t)) && simpleContext.getRetryCount() < this.maxAttempts;
    }

    public final void setRetryableExceptionClasses(Class[] retryableExceptionClasses) {
        this.retryableClassifier.setExceptionClasses(retryableExceptionClasses);
    }

    public final void setFatalExceptionClasses(Class[] fatalExceptionClasses) {
        this.fatalClassifier.setExceptionClasses(fatalExceptionClasses);
    }

    public void close(RetryContext status) {
    }

    public void registerThrowable(RetryContext context, Throwable throwable) {
        SimpleRetryContext simpleContext = (SimpleRetryContext)context;
        simpleContext.registerThrowable(throwable);
    }

    public RetryContext open(RetryCallback callback, RetryContext parent) {
        return new SimpleRetryContext(parent);
    }

    private boolean retryForException(Throwable ex) {
        return this.fatalClassifier.isDefault(ex) && !this.retryableClassifier.isDefault(ex);
    }

    private static class SimpleRetryContext
    extends RetryContextSupport {
        public SimpleRetryContext(RetryContext parent) {
            super(parent);
        }
    }
}

