/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.callback;

import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;

public class ItemReaderRepeatCallback
implements RepeatCallback {
    ItemReader provider;
    ItemWriter writer;

    public ItemReaderRepeatCallback(ItemReader provider, ItemWriter writer) {
        this.provider = provider;
        this.writer = writer;
    }

    public ItemReaderRepeatCallback(ItemReader provider) {
        this(provider, null);
    }

    public ExitStatus doInIteration(RepeatContext context) throws Exception {
        ExitStatus result = ExitStatus.FINISHED;
        Object item = this.provider.read();
        if (this.writer != null) {
            if (item != null) {
                this.writer.write(item);
                result = ExitStatus.CONTINUABLE;
            }
            item = null;
        }
        return result;
    }
}

