/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractBufferedItemReaderItemStream;
import org.springframework.batch.item.xml.EventReaderDeserializer;
import org.springframework.batch.item.xml.stax.DefaultFragmentEventReader;
import org.springframework.batch.item.xml.stax.FragmentEventReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class StaxEventItemReader
extends AbstractBufferedItemReaderItemStream
implements ResourceAwareItemReaderItemStream,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)StaxEventItemReader.class);
    private FragmentEventReader fragmentReader;
    private XMLEventReader eventReader;
    private EventReaderDeserializer eventReaderDeserializer;
    private Resource resource;
    private InputStream inputStream;
    private String fragmentRootElementName;
    private boolean noInput;

    public StaxEventItemReader() {
        this.setName(ClassUtils.getShortName((Class)StaxEventItemReader.class));
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setFragmentDeserializer(EventReaderDeserializer eventReaderDeserializer) {
        this.eventReaderDeserializer = eventReaderDeserializer;
    }

    public void setFragmentRootElementName(String fragmentRootElementName) {
        this.fragmentRootElementName = fragmentRootElementName;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.eventReaderDeserializer, (String)"The FragmentDeserializer must not be null.");
        Assert.hasLength((String)this.fragmentRootElementName, (String)"The FragmentRootElementName must not be null");
    }

    protected boolean moveCursorToNextFragment(XMLEventReader reader) {
        try {
            while (true) {
                if (reader.peek() != null && !reader.peek().isStartElement()) {
                    reader.nextEvent();
                    continue;
                }
                if (reader.peek() == null) {
                    return false;
                }
                QName startElementName = ((StartElement)reader.peek()).getName();
                if (startElementName.getLocalPart().equals(this.fragmentRootElementName)) {
                    return true;
                }
                reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new DataAccessResourceFailureException("Error while reading from event reader", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws Exception {
        try {
            if (this.fragmentReader != null) {
                this.fragmentReader.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.fragmentReader = null;
            this.inputStream = null;
        }
    }

    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"The Resource must not be null.");
        this.noInput = false;
        if (!this.resource.exists()) {
            this.noInput = true;
            logger.warn((Object)"Input resource does not exist");
            return;
        }
        this.inputStream = this.resource.getInputStream();
        this.eventReader = XMLInputFactory.newInstance().createXMLEventReader(this.inputStream);
        this.fragmentReader = new DefaultFragmentEventReader(this.eventReader);
    }

    protected Object doRead() throws Exception {
        if (this.noInput) {
            return null;
        }
        Object item = null;
        if (this.moveCursorToNextFragment(this.fragmentReader)) {
            this.fragmentReader.markStartFragment();
            item = this.eventReaderDeserializer.deserializeFragment(this.fragmentReader);
            this.fragmentReader.markFragmentProcessed();
        }
        return item;
    }
}

