/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DelegatingItemWriter
implements ItemWriter,
InitializingBean {
    private ItemWriter delegate;

    public DelegatingItemWriter() {
    }

    public DelegatingItemWriter(ItemWriter itemWriter) {
        this();
        this.delegate = itemWriter;
    }

    public void write(Object item) throws Exception {
        Object result = this.doProcess(item);
        this.delegate.write(result);
    }

    protected Object doProcess(Object item) throws Exception {
        return item;
    }

    public void setDelegate(ItemWriter writer) {
        this.delegate = writer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate);
    }

    public void clear() throws ClearFailedException {
        this.delegate.clear();
    }

    public void flush() throws FlushFailedException {
        this.delegate.flush();
    }
}

