/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.AbstractBufferedItemReaderItemStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HibernateCursorItemReader
extends AbstractBufferedItemReaderItemStream
implements ItemStream,
InitializingBean {
    private SessionFactory sessionFactory;
    private StatelessSession statelessSession;
    private Session statefulSession;
    private ScrollableResults cursor;
    private String queryString;
    private boolean useStatelessSession = true;
    private boolean initialized = false;
    private int fetchSize = 0;

    public HibernateCursorItemReader() {
        this.setName(ClassUtils.getShortName((Class)HibernateCursorItemReader.class));
    }

    private Query createQuery() {
        if (this.useStatelessSession) {
            this.statelessSession = this.sessionFactory.openStatelessSession();
            return this.statelessSession.createQuery(this.queryString);
        }
        this.statefulSession = this.sessionFactory.openSession();
        return this.statefulSession.createQuery(this.queryString);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionFactory);
        Assert.hasLength((String)this.queryString);
        Assert.isTrue((this.fetchSize >= 0 ? 1 : 0) != 0, (String)"fetchSize must not be negative");
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        Assert.state((!this.initialized ? 1 : 0) != 0);
        this.useStatelessSession = useStatelessSession;
    }

    public void mark() {
        super.mark();
        if (!this.useStatelessSession) {
            this.statefulSession.clear();
        }
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    protected Object doRead() throws Exception {
        if (this.cursor.next()) {
            Object[] data = this.cursor.get();
            Object item = data.length > 1 ? data : data[0];
            return item;
        }
        return null;
    }

    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened ItemReader, call close first");
        this.cursor = this.createQuery().setFetchSize(this.fetchSize).scroll(ScrollMode.FORWARD_ONLY);
        this.initialized = true;
    }

    protected void doClose() throws Exception {
        this.initialized = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.useStatelessSession) {
            if (this.statelessSession != null) {
                this.statelessSession.close();
            }
        } else if (this.statefulSession != null) {
            this.statefulSession.close();
        }
    }
}

