/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.springframework.batch.admin.web.JobParametersExtractor;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobInstanceInfo {
    private final JobInstance jobInstance;
    private final Long id;
    private final Collection<JobExecution> jobExecutions;
    private final Properties jobParameters;
    private final String jobParametersString;

    public JobInstanceInfo(JobInstance jobInstance, Collection<JobExecution> jobExecutions) {
        this.jobInstance = jobInstance;
        this.jobExecutions = jobExecutions != null ? jobExecutions : new ArrayList();
        this.id = jobInstance.getId();
        this.jobParameters = new DefaultJobParametersConverter().getProperties(jobInstance.getJobParameters());
        this.jobParametersString = new JobParametersExtractor().fromJobParameters(jobInstance.getJobParameters());
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public Long getId() {
        return this.id;
    }

    public int getJobExecutionCount() {
        return this.jobExecutions.size();
    }

    public Collection<JobExecution> getJobExecutions() {
        return this.jobExecutions;
    }

    public JobExecution getLastJobExecution() {
        return this.jobExecutions.isEmpty() ? null : this.jobExecutions.iterator().next();
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public String getJobParametersString() {
        return this.jobParametersString;
    }
}

