/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.util;

import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;

public class ThrottledTaskExecutor
implements TaskExecutor {
    private Semaphore semaphore;
    private volatile AtomicInteger count = new AtomicInteger(0);
    private TaskExecutor taskExecutor = new SyncTaskExecutor();

    public ThrottledTaskExecutor() {
        this(null, Integer.MAX_VALUE);
    }

    public ThrottledTaskExecutor(TaskExecutor taskExecutor) {
        this(taskExecutor, Integer.MAX_VALUE);
    }

    public ThrottledTaskExecutor(TaskExecutor taskExecutor, int throttleLimit) {
        if (taskExecutor != null) {
            this.taskExecutor = taskExecutor;
        }
        this.semaphore = new Semaphore(throttleLimit);
    }

    public void setThrottleLimit(int throttleLimit) {
        this.semaphore = new Semaphore(throttleLimit);
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException("Task is null in ThrottledTaskExecutor.");
        }
        this.doSubmit(task);
    }

    public int size() {
        return this.count.get();
    }

    private Runnable doSubmit(Runnable task) {
        try {
            this.semaphore.acquire();
            this.count.incrementAndGet();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TaskRejectedException("Task could not be submitted because of a thread interruption.");
        }
        try {
            this.taskExecutor.execute((Runnable)new FutureTask<Object>(task, null){

                @Override
                protected void done() {
                    ThrottledTaskExecutor.this.semaphore.release();
                    ThrottledTaskExecutor.this.count.decrementAndGet();
                }
            });
        }
        catch (TaskRejectedException e) {
            this.semaphore.release();
            this.count.decrementAndGet();
            throw e;
        }
        return task;
    }
}

