/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.io.IOException;
import org.springframework.batch.admin.integration.JobConfigurationRequest;
import org.springframework.web.multipart.MultipartFile;

public class MultipartJobConfigurationRequest {
    private MultipartFile file;

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public JobConfigurationRequest getJobConfigurationRequest() {
        JobConfigurationRequest jobConfigurationRequest = new JobConfigurationRequest();
        if (this.file == null) {
            jobConfigurationRequest.setXml("");
            return jobConfigurationRequest;
        }
        try {
            jobConfigurationRequest.setXml(new String(this.file.getBytes()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot extract file from multipart", e);
        }
        jobConfigurationRequest.setFileName(this.file.getOriginalFilename());
        return jobConfigurationRequest;
    }
}

