/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.io.File;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.Assert;

@MessageEndpoint
public class FileToJobLaunchRequestAdapter
implements InitializingBean {
    private Job job;

    public void setJob(Job job) {
        this.job = job;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.job, (String)"A Job must be provided");
    }

    @ServiceActivator
    public JobLaunchRequest adapt(File file) throws NoSuchJobException {
        String fileName = file.getAbsolutePath();
        if (!fileName.startsWith("/")) {
            fileName = "/" + fileName;
        }
        fileName = "file://" + fileName;
        JobParameters jobParameters = new JobParametersBuilder().addString("input.file", fileName).toJobParameters();
        if (this.job.getJobParametersIncrementer() != null) {
            jobParameters = this.job.getJobParametersIncrementer().getNext(jobParameters);
        }
        return new JobLaunchRequest(this.job, jobParameters);
    }
}

