/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatefulRetryOperationsInterceptor;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;

public class StatefulRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private MessageKeyGenerator messageKeyGenerator = message -> {
        MessageProperties messageProperties = message.getMessageProperties();
        String messageId = messageProperties.getMessageId();
        if (messageId == null && Boolean.TRUE.equals(messageProperties.isRedelivered())) {
            messageProperties.setFinalRetryForMessageWithNoId(true);
        }
        return messageId;
    };
    private NewMessageIdentifier newMessageIdentifier = message -> Boolean.FALSE.equals(message.getMessageProperties().isRedelivered());
    private @Nullable Integer stateCacheSize;

    public void setMessageKeyGenerator(MessageKeyGenerator messageKeyGenerator) {
        this.messageKeyGenerator = messageKeyGenerator;
    }

    public void setNewMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
        this.newMessageIdentifier = newMessageIdentifier;
    }

    public void setStateCacheSize(int stateCacheSize) {
        this.stateCacheSize = stateCacheSize;
    }

    public StatefulRetryOperationsInterceptor getObject() {
        return new StatefulRetryOperationsInterceptor(this.messageKeyGenerator, this.newMessageIdentifier, this.getRetryPolicy(), this.getMessageRecoverer(), this.stateCacheSize);
    }

    public Class<?> getObjectType() {
        return StatefulRetryOperationsInterceptor.class;
    }
}

