/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.Arrays;
import java.util.function.Function;
import org.aopalliance.aop.Advice;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.ReplyPostProcessor;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.util.Assert;

public abstract class BaseRabbitListenerContainerFactory<C extends MessageListenerContainer>
implements RabbitListenerContainerFactory<C>,
ApplicationContextAware {
    private @Nullable Boolean defaultRequeueRejected;
    private MessagePostProcessor @Nullable [] beforeSendReplyPostProcessors;
    private @Nullable RetryTemplate retryTemplate;
    private @Nullable MessageRecoverer recoveryCallback;
    private Advice @Nullable [] adviceChain;
    private @Nullable Function<@Nullable String, @Nullable ReplyPostProcessor> replyPostProcessorProvider;
    private @Nullable Boolean micrometerEnabled;
    private @Nullable Boolean observationEnabled;
    private ApplicationContext applicationContext;
    private @Nullable String beanName;

    @Override
    public abstract C createListenerContainer(@Nullable RabbitListenerEndpoint var1);

    public void setDefaultRequeueRejected(Boolean requeueRejected) {
        this.defaultRequeueRejected = requeueRejected;
    }

    protected @Nullable Boolean getDefaultRequeueRejected() {
        return this.defaultRequeueRejected;
    }

    public void setBeforeSendReplyPostProcessors(MessagePostProcessor ... postProcessors) {
        Assert.notNull((Object)postProcessors, (String)"'postProcessors' cannot be null");
        Assert.noNullElements((Object[])postProcessors, (String)"'postProcessors' cannot have null elements");
        this.beforeSendReplyPostProcessors = Arrays.copyOf(postProcessors, postProcessors.length);
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setReplyRecoveryCallback(MessageRecoverer recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setReplyPostProcessorProvider(Function<@Nullable String, @Nullable ReplyPostProcessor> replyPostProcessorProvider) {
        this.replyPostProcessorProvider = replyPostProcessorProvider;
    }

    protected void applyCommonOverrides(@Nullable RabbitListenerEndpoint endpoint, C instance) {
        Object iml;
        if (endpoint != null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)endpoint.getAutoStartup(), arg_0 -> instance.setAutoStartup(arg_0)).acceptIfNotNull((Object)endpoint.getId(), arg_0 -> instance.setListenerId(arg_0));
            endpoint.setupListenerContainer((MessageListenerContainer)instance);
        }
        if ((iml = instance.getMessageListener()) instanceof AbstractAdaptableMessageListener) {
            AbstractAdaptableMessageListener messageListener = (AbstractAdaptableMessageListener)iml;
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.beforeSendReplyPostProcessors, messageListener::setBeforeSendReplyPostProcessors).acceptIfNotNull((Object)this.retryTemplate, messageListener::setRetryTemplate).acceptIfCondition(this.retryTemplate != null && this.recoveryCallback != null, (Object)this.recoveryCallback, messageListener::setRecoveryCallback).acceptIfNotNull((Object)this.defaultRequeueRejected, messageListener::setDefaultRequeueRejected);
            if (endpoint != null) {
                JavaUtils.INSTANCE.acceptIfNotNull((Object)endpoint.getReplyPostProcessor(), messageListener::setReplyPostProcessor).acceptIfNotNull((Object)endpoint.getReplyContentType(), messageListener::setReplyContentType);
                messageListener.setConverterWinsContentType(endpoint.isConverterWinsContentType());
                if (endpoint.getReplyPostProcessor() == null && this.replyPostProcessorProvider != null) {
                    JavaUtils.INSTANCE.acceptIfNotNull((Object)this.replyPostProcessorProvider.apply(endpoint.getId()), messageListener::setReplyPostProcessor);
                }
            }
        }
    }

    public Advice @Nullable [] getAdviceChain() {
        return this.adviceChain == null ? null : Arrays.copyOf(this.adviceChain, this.adviceChain.length);
    }

    public void setAdviceChain(Advice ... adviceChain) {
        this.adviceChain = adviceChain == null ? null : Arrays.copyOf(adviceChain, adviceChain.length);
    }

    public void setMicrometerEnabled(boolean micrometerEnabled) {
        this.micrometerEnabled = micrometerEnabled;
    }

    protected @Nullable Boolean getMicrometerEnabled() {
        return this.micrometerEnabled;
    }

    public void setObservationEnabled(boolean observationEnabled) {
        this.observationEnabled = observationEnabled;
    }

    protected @Nullable Boolean getObservationEnabled() {
        return this.observationEnabled;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public @Nullable String getBeanName() {
        return this.beanName;
    }
}

