/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.ReplyPostProcessor;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.task.TaskExecutor;
import org.springframework.expression.BeanResolver;
import org.springframework.util.Assert;

public abstract class AbstractRabbitListenerEndpoint
implements RabbitListenerEndpoint,
BeanFactoryAware {
    private @Nullable String id;
    private final Collection<Queue> queues = new ArrayList<Queue>();
    private final Collection<String> queueNames = new ArrayList<String>();
    private boolean exclusive;
    private @Nullable Integer priority;
    private @Nullable String concurrency;
    private @Nullable AmqpAdmin admin;
    private @Nullable BeanFactory beanFactory;
    private @Nullable BeanExpressionResolver resolver;
    private @Nullable BeanExpressionContext expressionContext;
    private @Nullable BeanResolver beanResolver;
    private @Nullable String group;
    private @Nullable Boolean autoStartup;
    private @Nullable MessageConverter messageConverter;
    private @Nullable TaskExecutor taskExecutor;
    private @Nullable Boolean batchListener;
    private @Nullable BatchingStrategy batchingStrategy;
    private @Nullable AcknowledgeMode ackMode;
    private @Nullable ReplyPostProcessor replyPostProcessor;
    private @Nullable String replyContentType;
    private boolean converterWinsContentType = true;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
            this.resolver = clbf.getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)clbf, null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    protected @Nullable BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected @Nullable BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    protected @Nullable BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    protected @Nullable BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public @Nullable String getId() {
        return this.id;
    }

    public void setQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' must not be null");
        this.queues.clear();
        this.queues.addAll(Arrays.asList(queues));
    }

    public Collection<Queue> getQueues() {
        return this.queues;
    }

    public Collection<String> getQueueNames() {
        return this.queueNames;
    }

    public void setQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' must not be null");
        this.queueNames.clear();
        this.queueNames.addAll(Arrays.asList(queueNames));
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public @Nullable Integer getPriority() {
        return this.priority;
    }

    public void setConcurrency(@Nullable String concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public @Nullable String getConcurrency() {
        return this.concurrency;
    }

    public void setAdmin(AmqpAdmin admin) {
        this.admin = admin;
    }

    public @Nullable AmqpAdmin getAdmin() {
        return this.admin;
    }

    @Override
    public @Nullable String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public @Nullable Boolean getAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public @Nullable MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    @Override
    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    public @Nullable TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isBatchListener() {
        return this.batchListener != null && this.batchListener != false;
    }

    @Override
    public @Nullable Boolean getBatchListener() {
        return this.batchListener;
    }

    @Override
    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    @Override
    public @Nullable BatchingStrategy getBatchingStrategy() {
        return this.batchingStrategy;
    }

    @Override
    public void setBatchingStrategy(BatchingStrategy batchingStrategy) {
        this.batchingStrategy = batchingStrategy;
    }

    @Override
    public @Nullable AcknowledgeMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AcknowledgeMode mode) {
        this.ackMode = mode;
    }

    @Override
    public @Nullable ReplyPostProcessor getReplyPostProcessor() {
        return this.replyPostProcessor;
    }

    public void setReplyPostProcessor(ReplyPostProcessor replyPostProcessor) {
        this.replyPostProcessor = replyPostProcessor;
    }

    @Override
    public @Nullable String getReplyContentType() {
        return this.replyContentType;
    }

    public void setReplyContentType(String replyContentType) {
        this.replyContentType = replyContentType;
    }

    @Override
    public boolean isConverterWinsContentType() {
        return this.converterWinsContentType;
    }

    public void setConverterWinsContentType(boolean converterWinsContentType) {
        this.converterWinsContentType = converterWinsContentType;
    }

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer) {
        Collection<String> qNames = this.getQueueNames();
        boolean queueNamesEmpty = qNames.isEmpty();
        if (listenerContainer instanceof AbstractMessageListenerContainer) {
            AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
            boolean queuesEmpty = this.getQueues().isEmpty();
            if (!queuesEmpty && !queueNamesEmpty) {
                throw new IllegalStateException("Queues or queue names must be provided but not both for " + String.valueOf(this));
            }
            if (queuesEmpty) {
                container.setQueueNames(qNames.toArray(new String[0]));
            } else {
                Collection<Queue> instances = this.getQueues();
                container.setQueues(instances.toArray(new Queue[0]));
            }
            container.setExclusive(this.isExclusive());
            if (this.getPriority() != null) {
                Map<String, Object> args = container.getConsumerArguments();
                args.put("x-priority", this.getPriority());
                container.setConsumerArguments(args);
            }
            if (this.getAdmin() != null) {
                container.setAmqpAdmin(this.getAdmin());
            }
        } else {
            Assert.state((!queueNamesEmpty ? 1 : 0) != 0, (String)"At least one queue name is required");
            listenerContainer.setQueueNames(qNames.toArray(new String[0]));
        }
        this.setupMessageListener(listenerContainer);
    }

    protected abstract @Nullable MessageListener createMessageListener(MessageListenerContainer var1);

    private void setupMessageListener(MessageListenerContainer container) {
        MessageListener messageListener = this.createMessageListener(container);
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + String.valueOf(this) + "] must provide a non null message listener");
        container.setupMessageListener(messageListener);
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] queues=").append(this.queues).append("' | queueNames='").append(this.queueNames).append("' | exclusive='").append(this.exclusive).append("' | priority='").append(this.priority).append("' | admin='").append(this.admin).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }
}

