/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.support;

import org.apache.commons.logging.Log;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.ImmediateRequeueAmqpException;
import org.springframework.amqp.rabbit.listener.exception.MessageRejectedWhileStoppingException;

public final class ContainerUtils {
    private ContainerUtils() {
    }

    public static boolean shouldRequeue(boolean defaultRequeueRejected, Throwable throwable, Log logger) {
        boolean shouldRequeue = defaultRequeueRejected || throwable instanceof MessageRejectedWhileStoppingException;
        Throwable t = throwable;
        while (t != null) {
            if (t instanceof AmqpRejectAndDontRequeueException) {
                shouldRequeue = false;
                break;
            }
            if (t instanceof ImmediateRequeueAmqpException) {
                shouldRequeue = true;
                break;
            }
            Throwable cause = t.getCause();
            if (cause == t) break;
            t = cause;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rejecting messages (requeue=" + shouldRequeue + ")"));
        }
        return shouldRequeue;
    }

    public static boolean isRejectManual(Throwable ex) {
        AmqpRejectAndDontRequeueException amqpRejectAndDontRequeueException = ContainerUtils.findInCause(ex, AmqpRejectAndDontRequeueException.class);
        return amqpRejectAndDontRequeueException != null && amqpRejectAndDontRequeueException.isRejectManual();
    }

    public static boolean isImmediateAcknowledge(Throwable ex) {
        return ContainerUtils.findInCause(ex, ImmediateAcknowledgeAmqpException.class) != null;
    }

    public static boolean isAmqpReject(Throwable ex) {
        return ContainerUtils.findInCause(ex, AmqpRejectAndDontRequeueException.class) != null;
    }

    private static <T extends Throwable> @Nullable T findInCause(Throwable throwable, Class<T> exceptionToFind) {
        if (exceptionToFind.isAssignableFrom(throwable.getClass())) {
            return (T)throwable;
        }
        Throwable cause = throwable.getCause();
        if (cause == null || cause == throwable) {
            return null;
        }
        return ContainerUtils.findInCause(cause, exceptionToFind);
    }
}

