/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.ConfirmCallback;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.context.Lifecycle;
import org.springframework.core.ParameterizedTypeReference;

public interface RabbitOperations
extends AmqpTemplate,
Lifecycle {
    public <T> @Nullable T execute(ChannelCallback<T> var1) throws AmqpException;

    default public <T> @Nullable T invoke(OperationsCallback<T> action) throws AmqpException {
        return this.invoke(action, null, null);
    }

    public <T> @Nullable T invoke(OperationsCallback<T> var1, @Nullable ConfirmCallback var2, @Nullable ConfirmCallback var3);

    public boolean waitForConfirms(long var1) throws AmqpException;

    public void waitForConfirmsOrDie(long var1) throws AmqpException;

    public ConnectionFactory getConnectionFactory();

    default public void send(String routingKey, Message message, CorrelationData correlationData) throws AmqpException {
        throw new UnsupportedOperationException("This implementation does not support this method");
    }

    public void send(String var1, String var2, Message var3, @Nullable CorrelationData var4) throws AmqpException;

    public void correlationConvertAndSend(Object var1, CorrelationData var2) throws AmqpException;

    public void convertAndSend(String var1, Object var2, CorrelationData var3) throws AmqpException;

    public void convertAndSend(String var1, String var2, Object var3, CorrelationData var4) throws AmqpException;

    public void convertAndSend(Object var1, MessagePostProcessor var2, CorrelationData var3) throws AmqpException;

    public void convertAndSend(String var1, Object var2, MessagePostProcessor var3, CorrelationData var4) throws AmqpException;

    public void convertAndSend(String var1, String var2, Object var3, MessagePostProcessor var4, @Nullable CorrelationData var5) throws AmqpException;

    public @Nullable Object convertSendAndReceive(Object var1, CorrelationData var2) throws AmqpException;

    public @Nullable Object convertSendAndReceive(String var1, Object var2, CorrelationData var3) throws AmqpException;

    public @Nullable Object convertSendAndReceive(String var1, String var2, Object var3, CorrelationData var4) throws AmqpException;

    public @Nullable Object convertSendAndReceive(Object var1, MessagePostProcessor var2, @Nullable CorrelationData var3) throws AmqpException;

    public @Nullable Object convertSendAndReceive(String var1, Object var2, MessagePostProcessor var3, @Nullable CorrelationData var4) throws AmqpException;

    public @Nullable Object convertSendAndReceive(String var1, String var2, Object var3, @Nullable MessagePostProcessor var4, @Nullable CorrelationData var5) throws AmqpException;

    public <T> @Nullable T convertSendAndReceiveAsType(Object var1, @Nullable CorrelationData var2, ParameterizedTypeReference<T> var3) throws AmqpException;

    public <T> @Nullable T convertSendAndReceiveAsType(String var1, Object var2, @Nullable CorrelationData var3, ParameterizedTypeReference<T> var4) throws AmqpException;

    default public <T> @Nullable T convertSendAndReceiveAsType(String exchange, String routingKey, Object message, @Nullable CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(exchange, routingKey, message, null, correlationData, responseType);
    }

    public <T> @Nullable T convertSendAndReceiveAsType(Object var1, @Nullable MessagePostProcessor var2, @Nullable CorrelationData var3, ParameterizedTypeReference<T> var4) throws AmqpException;

    public <T> @Nullable T convertSendAndReceiveAsType(String var1, Object var2, @Nullable MessagePostProcessor var3, @Nullable CorrelationData var4, ParameterizedTypeReference<T> var5) throws AmqpException;

    public <T> @Nullable T convertSendAndReceiveAsType(String var1, String var2, Object var3, @Nullable MessagePostProcessor var4, @Nullable CorrelationData var5, ParameterizedTypeReference<T> var6) throws AmqpException;

    default public void start() {
    }

    default public void stop() {
    }

    default public boolean isRunning() {
        return false;
    }

    @FunctionalInterface
    public static interface OperationsCallback<T> {
        public @Nullable T doInRabbit(RabbitOperations var1);
    }
}

