/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.batch.MessageBatch;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.scheduling.TaskScheduler;

public class BatchingRabbitTemplate
extends RabbitTemplate {
    private final Lock lock = new ReentrantLock();
    private final BatchingStrategy batchingStrategy;
    private final TaskScheduler scheduler;
    private volatile @Nullable ScheduledFuture<?> scheduledTask;

    public BatchingRabbitTemplate(BatchingStrategy batchingStrategy, TaskScheduler scheduler) {
        this.batchingStrategy = batchingStrategy;
        this.scheduler = scheduler;
    }

    public BatchingRabbitTemplate(ConnectionFactory connectionFactory, BatchingStrategy batchingStrategy, TaskScheduler scheduler) {
        super(connectionFactory);
        this.batchingStrategy = batchingStrategy;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@Nullable String exchange, @Nullable String routingKey, Message message, @Nullable CorrelationData correlationData) throws AmqpException {
        this.lock.lock();
        try {
            if (correlationData != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Cannot use batching with correlation data");
                }
                super.send(exchange, routingKey, message, correlationData);
            } else {
                Date next;
                MessageBatch batch;
                if (this.scheduledTask != null) {
                    this.scheduledTask.cancel(false);
                }
                if ((batch = this.batchingStrategy.addToBatch(exchange, routingKey, message)) != null) {
                    super.send(batch.exchange(), batch.routingKey(), batch.message(), null);
                }
                if ((next = this.batchingStrategy.nextRelease()) != null) {
                    this.scheduledTask = this.scheduler.schedule(this::releaseBatches, next.toInstant());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void flush() {
        this.releaseBatches();
    }

    private void releaseBatches() {
        this.lock.lock();
        try {
            for (MessageBatch batch : this.batchingStrategy.releaseBatches()) {
                super.send(batch.exchange(), batch.routingKey(), batch.message(), null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void doStart() {
    }

    @Override
    public void doStop() {
        this.flush();
    }

    @Override
    public boolean isRunning() {
        return true;
    }
}

