/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.NodeLocator;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LocalizedQueueConnectionFactory
implements ConnectionFactory,
RoutingConnectionFactory,
DisposableBean,
SmartLifecycle {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Lock lock = new ReentrantLock();
    private final Map<String, ConnectionFactory> nodeFactories = new HashMap<String, ConnectionFactory>();
    private final ConnectionFactory defaultConnectionFactory;
    private final String[] adminUris;
    private final Map<String, String> nodeToAddress = new HashMap<String, String>();
    private final String vhost;
    private final String username;
    private final String password;
    private final boolean useSSL;
    private final Resource sslPropertiesLocation;
    private final String keyStore;
    private final String trustStore;
    private final String keyStorePassPhrase;
    private final String trustStorePassPhrase;
    private final AtomicBoolean running = new AtomicBoolean();
    private NodeLocator<?> nodeLocator;

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, Map<String, String> nodeToAddress, String[] adminUris, String vhost, String username, String password, boolean useSSL, Resource sslPropertiesLocation) {
        this(defaultConnectionFactory, adminUris, nodeToAddress, vhost, username, password, useSSL, sslPropertiesLocation, null, null, null, null);
    }

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, Map<String, String> nodeToAddress, String[] adminUris, String vhost, String username, String password, boolean useSSL, String keyStore, String trustStore, String keyStorePassPhrase, String trustStorePassPhrase) {
        this(defaultConnectionFactory, adminUris, nodeToAddress, vhost, username, password, useSSL, null, keyStore, trustStore, keyStorePassPhrase, trustStorePassPhrase);
    }

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, String[] addresses, String[] adminUris, String[] nodes, String vhost, String username, String password, boolean useSSL, @Nullable Resource sslPropertiesLocation) {
        this(defaultConnectionFactory, adminUris, LocalizedQueueConnectionFactory.nodesAddressesToMap(nodes, addresses), vhost, username, password, useSSL, sslPropertiesLocation, null, null, null, null);
    }

    public LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, String[] addresses, String[] adminUris, String[] nodes, String vhost, String username, String password, boolean useSSL, String keyStore, String trustStore, String keyStorePassPhrase, String trustStorePassPhrase) {
        this(defaultConnectionFactory, adminUris, LocalizedQueueConnectionFactory.nodesAddressesToMap(nodes, addresses), vhost, username, password, useSSL, null, keyStore, trustStore, keyStorePassPhrase, trustStorePassPhrase);
    }

    private LocalizedQueueConnectionFactory(ConnectionFactory defaultConnectionFactory, String[] adminUris, Map<String, String> nodeToAddress, String vhost, String username, String password, boolean useSSL, @Nullable Resource sslPropertiesLocation, @Nullable String keyStore, @Nullable String trustStore, @Nullable String keyStorePassPhrase, @Nullable String trustStorePassPhrase) {
        Assert.notNull((Object)defaultConnectionFactory, (String)"'defaultConnectionFactory' cannot be null");
        this.defaultConnectionFactory = defaultConnectionFactory;
        this.adminUris = Arrays.copyOf(adminUris, adminUris.length);
        this.nodeToAddress.putAll(nodeToAddress);
        this.vhost = vhost;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
        this.sslPropertiesLocation = sslPropertiesLocation;
        this.keyStore = keyStore;
        this.trustStore = trustStore;
        this.keyStorePassPhrase = keyStorePassPhrase;
        this.trustStorePassPhrase = trustStorePassPhrase;
        this.nodeLocator = ConnectionFactoryUtils.nodeLocator();
    }

    private static Map<String, String> nodesAddressesToMap(String[] nodes, String[] addresses) {
        Assert.isTrue((addresses.length == nodes.length ? 1 : 0) != 0, (String)"'addresses' and 'nodes' properties must have equal length");
        return IntStream.range(0, addresses.length).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<String, String>(nodes[i], addresses[i])).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
    }

    public void setNodeLocator(NodeLocator<?> nodeLocator) {
        Assert.notNull(nodeLocator, (String)"'nodeLocator' cannot be null");
        this.nodeLocator = nodeLocator;
    }

    @Override
    public Connection createConnection() throws AmqpException {
        return this.defaultConnectionFactory.createConnection();
    }

    @Override
    public String getHost() {
        return this.defaultConnectionFactory.getHost();
    }

    @Override
    public int getPort() {
        return this.defaultConnectionFactory.getPort();
    }

    @Override
    public String getVirtualHost() {
        return this.vhost;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        this.running.set(false);
        this.resetConnection();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.defaultConnectionFactory.addConnectionListener(listener);
    }

    @Override
    public boolean removeConnectionListener(ConnectionListener listener) {
        return this.defaultConnectionFactory.removeConnectionListener(listener);
    }

    @Override
    public void clearConnectionListeners() {
        this.defaultConnectionFactory.clearConnectionListeners();
    }

    @Override
    public ConnectionFactory getTargetConnectionFactory(Object key) {
        String queue = (String)key;
        Assert.isTrue((!(queue = queue.substring(1, queue.length() - 1)).contains(",") ? 1 : 0) != 0, () -> "Cannot use LocalizedQueueConnectionFactory with more than one queue: " + String.valueOf(key));
        ConnectionFactory connectionFactory = this.determineConnectionFactory(queue);
        if (connectionFactory == null) {
            return this.defaultConnectionFactory;
        }
        return connectionFactory;
    }

    @Nullable
    private ConnectionFactory determineConnectionFactory(String queue) {
        ConnectionFactory cf = this.nodeLocator.locate(this.adminUris, this.nodeToAddress, this.vhost, this.username, this.password, queue, this::nodeConnectionFactory);
        if (cf == null) {
            this.logger.warn((Object)("Failed to determine queue location for: " + queue + ", using default connection factory"));
        }
        return cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionFactory nodeConnectionFactory(String queue, String node, String address) {
        this.lock.lock();
        try {
            ConnectionFactory cf;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Queue: " + queue + " is on node: " + node + " at: " + address));
            }
            if ((cf = this.nodeFactories.get(node)) == null) {
                cf = this.createConnectionFactory(address, node);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Created new connection factory: " + String.valueOf(cf)));
                }
                this.nodeFactories.put(node, cf);
            }
            ConnectionFactory connectionFactory = cf;
            return connectionFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ConnectionFactory createConnectionFactory(String address, String node) {
        com.rabbitmq.client.ConnectionFactory rcf;
        RabbitConnectionFactoryBean rcfb = new RabbitConnectionFactoryBean();
        rcfb.setUseSSL(this.useSSL);
        rcfb.setSslPropertiesLocation(this.sslPropertiesLocation);
        rcfb.setKeyStore(this.keyStore);
        rcfb.setTrustStore(this.trustStore);
        rcfb.setKeyStorePassphrase(this.keyStorePassPhrase);
        rcfb.setTrustStorePassphrase(this.trustStorePassPhrase);
        rcfb.afterPropertiesSet();
        try {
            rcf = (com.rabbitmq.client.ConnectionFactory)rcfb.getObject();
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        CachingConnectionFactory ccf = new CachingConnectionFactory(rcf);
        ccf.setAddresses(address);
        ccf.setUsername(this.username);
        ccf.setPassword(this.password);
        ccf.setVirtualHost(this.vhost);
        ccf.setBeanName("node:" + node);
        return ccf;
    }

    @Override
    public void resetConnection() {
        Exception lastException = null;
        for (ConnectionFactory connectionFactory : this.nodeFactories.values()) {
            if (!(connectionFactory instanceof DisposableBean)) continue;
            DisposableBean disposable = (DisposableBean)connectionFactory;
            try {
                disposable.destroy();
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(lastException);
        }
    }

    public void destroy() {
        this.resetConnection();
    }
}

