/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.core.AmqpMessageReturnedException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.AmqpNackReceivedException;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.retry.RepublishMessageRecoverer;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.expression.Expression;
import org.springframework.lang.Nullable;

public class RepublishMessageRecovererWithConfirms
extends RepublishMessageRecoverer {
    private static final long DEFAULT_TIMEOUT = 10000L;
    private final RabbitTemplate template;
    private final CachingConnectionFactory.ConfirmType confirmType;
    private long confirmTimeout = 10000L;

    public RepublishMessageRecovererWithConfirms(RabbitTemplate errorTemplate, CachingConnectionFactory.ConfirmType confirmType) {
        this(errorTemplate, (Expression)null, null, confirmType);
    }

    public RepublishMessageRecovererWithConfirms(RabbitTemplate errorTemplate, String errorExchange, CachingConnectionFactory.ConfirmType confirmType) {
        this(errorTemplate, errorExchange, null, confirmType);
    }

    public RepublishMessageRecovererWithConfirms(RabbitTemplate errorTemplate, String errorExchange, String errorRoutingKey, CachingConnectionFactory.ConfirmType confirmType) {
        super((AmqpTemplate)errorTemplate, errorExchange, errorRoutingKey);
        this.template = errorTemplate;
        this.confirmType = confirmType;
    }

    public RepublishMessageRecovererWithConfirms(RabbitTemplate errorTemplate, @Nullable Expression errorExchange, @Nullable Expression errorRoutingKey, CachingConnectionFactory.ConfirmType confirmType) {
        super((AmqpTemplate)errorTemplate, errorExchange, errorRoutingKey);
        this.template = errorTemplate;
        this.confirmType = confirmType;
    }

    public void setConfirmTimeout(long confirmTimeout) {
        this.confirmTimeout = confirmTimeout;
    }

    @Override
    protected void doSend(@Nullable String exchange, String routingKey, Message message) {
        if (CachingConnectionFactory.ConfirmType.CORRELATED.equals((Object)this.confirmType)) {
            this.doSendCorrelated(exchange, routingKey, message);
        } else {
            this.doSendSimple(exchange, routingKey, message);
        }
    }

    private void doSendCorrelated(String exchange, String routingKey, Message message) {
        CorrelationData cd = new CorrelationData();
        if (exchange != null) {
            this.template.send(exchange, routingKey, message, cd);
        } else {
            this.template.send(routingKey, message, cd);
        }
        try {
            CorrelationData.Confirm confirm = cd.getFuture().get(this.confirmTimeout, TimeUnit.MILLISECONDS);
            if (cd.getReturned() != null) {
                throw new AmqpMessageReturnedException("Message returned", cd.getReturned());
            }
            if (!confirm.isAck()) {
                throw new AmqpNackReceivedException("Negative acknowledgment received", message);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
        catch (ExecutionException ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex.getCause());
        }
        catch (TimeoutException ex) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(ex);
        }
    }

    private void doSendSimple(String exchange, String routingKey, Message message) {
        this.template.invoke(sender -> {
            if (exchange != null) {
                sender.send(exchange, routingKey, message);
            } else {
                sender.send(routingKey, message);
            }
            sender.waitForConfirmsOrDie(this.confirmTimeout);
            return null;
        });
    }
}

