/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.AfterCompletionFailedException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConsumerChannelRegistry;
import org.springframework.amqp.rabbit.connection.NodeLocator;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.RestTemplateNodeLocator;
import org.springframework.amqp.rabbit.connection.WebFluxNodeLocator;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class ConnectionFactoryUtils {
    private static final boolean WEB_FLUX_PRESENT = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient", (ClassLoader)ConnectionFactoryUtils.class.getClassLoader());
    private static final ThreadLocal<AfterCompletionFailedException> COMPLETION_EXCEPTIONS = new ThreadLocal();
    private static boolean captureAfterCompletionExceptions;

    private ConnectionFactoryUtils() {
    }

    public static boolean isChannelTransactional(Channel channel, ConnectionFactory connectionFactory) {
        if (channel == null || connectionFactory == null) {
            return false;
        }
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        return resourceHolder != null && resourceHolder.containsChannel(channel);
    }

    public static RabbitResourceHolder getTransactionalResourceHolder(ConnectionFactory connectionFactory, boolean synchedLocalTransactionAllowed) {
        return ConnectionFactoryUtils.getTransactionalResourceHolder(connectionFactory, synchedLocalTransactionAllowed, false);
    }

    public static RabbitResourceHolder getTransactionalResourceHolder(ConnectionFactory connectionFactory, boolean synchedLocalTransactionAllowed, boolean publisherConnectionIfPossible) {
        return ConnectionFactoryUtils.doGetTransactionalResourceHolder(connectionFactory, new RabbitResourceFactory(connectionFactory, synchedLocalTransactionAllowed, publisherConnectionIfPossible));
    }

    private static RabbitResourceHolder doGetTransactionalResourceHolder(ConnectionFactory connectionFactory, ResourceFactory resourceFactory) {
        Channel channel;
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        Assert.notNull((Object)resourceFactory, (String)"ResourceFactory must not be null");
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        if (resourceHolder != null && (channel = resourceFactory.getChannel(resourceHolder)) != null) {
            return resourceHolder;
        }
        RabbitResourceHolder resourceHolderToUse = resourceHolder;
        if (resourceHolderToUse == null) {
            resourceHolderToUse = new RabbitResourceHolder();
        }
        Connection connection = resourceFactory.getConnection(resourceHolderToUse);
        Channel channel2 = null;
        try {
            channel2 = ConsumerChannelRegistry.getConsumerChannel(connectionFactory);
            if (channel2 == null && connection == null) {
                connection = resourceFactory.createConnection();
                if (resourceHolder == null && (resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory))) != null) {
                    channel2 = resourceHolder.getChannel();
                    resourceHolderToUse = resourceHolder;
                }
                resourceHolderToUse.addConnection(connection);
            }
            if (channel2 == null) {
                channel2 = resourceFactory.createChannel(connection);
            }
            resourceHolderToUse.addChannel(channel2, connection);
            if (!((Object)((Object)resourceHolderToUse)).equals((Object)resourceHolder) && TransactionSynchronizationManager.isSynchronizationActive()) {
                ConnectionFactoryUtils.bindResourceToTransaction(resourceHolderToUse, connectionFactory, resourceFactory.isSynchedLocalTransactionAllowed());
            }
            return resourceHolderToUse;
        }
        catch (IOException ex) {
            RabbitUtils.closeConnection(connection);
            throw new AmqpIOException(ex);
        }
    }

    public static void releaseResources(@Nullable RabbitResourceHolder resourceHolder) {
        if (resourceHolder == null || resourceHolder.isSynchronizedWithTransaction()) {
            return;
        }
        RabbitUtils.closeChannel(resourceHolder.getChannel());
        RabbitUtils.closeConnection(resourceHolder.getConnection());
    }

    public static RabbitResourceHolder bindResourceToTransaction(RabbitResourceHolder resourceHolder, ConnectionFactory connectionFactory, boolean synched) {
        if (TransactionSynchronizationManager.hasResource((Object)connectionFactory) || !TransactionSynchronizationManager.isActualTransactionActive() || !synched) {
            return (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        }
        TransactionSynchronizationManager.bindResource((Object)connectionFactory, (Object)((Object)resourceHolder));
        resourceHolder.setSynchronizedWithTransaction(true);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new RabbitResourceSynchronization(resourceHolder, connectionFactory, ConnectionFactoryUtils::completionFailed));
        }
        return resourceHolder;
    }

    private static void completionFailed(AfterCompletionFailedException ex) {
        if (captureAfterCompletionExceptions) {
            COMPLETION_EXCEPTIONS.set(ex);
        }
    }

    public static void enableAfterCompletionFailureCapture(boolean enable) {
        captureAfterCompletionExceptions = enable;
    }

    public static void checkAfterCompletion() {
        AfterCompletionFailedException ex = COMPLETION_EXCEPTIONS.get();
        if (ex != null) {
            COMPLETION_EXCEPTIONS.remove();
            throw ex;
        }
    }

    public static void registerDeliveryTag(ConnectionFactory connectionFactory, Channel channel, Long tag) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)connectionFactory));
        if (resourceHolder != null) {
            resourceHolder.addDeliveryTag(channel, tag);
        }
    }

    public static Connection createConnection(ConnectionFactory connectionFactory, boolean publisherConnectionIfPossible) {
        ConnectionFactory publisherFactory;
        if (publisherConnectionIfPossible && (publisherFactory = connectionFactory.getPublisherConnectionFactory()) != null) {
            return publisherFactory.createConnection();
        }
        return connectionFactory.createConnection();
    }

    static NodeLocator<?> nodeLocator() {
        if (WEB_FLUX_PRESENT) {
            return new WebFluxNodeLocator();
        }
        return new RestTemplateNodeLocator();
    }

    private static class RabbitResourceFactory
    implements ResourceFactory {
        private final ConnectionFactory connectionFactory;
        private final boolean synchedLocalTransactionAllowed;
        private final boolean publisherConnectionIfPossible;

        RabbitResourceFactory(ConnectionFactory connectionFactory, boolean synchedLocalTransactionAllowed, boolean publisherConnectionIfPossible) {
            this.connectionFactory = connectionFactory;
            this.synchedLocalTransactionAllowed = synchedLocalTransactionAllowed;
            this.publisherConnectionIfPossible = publisherConnectionIfPossible;
        }

        @Override
        @Nullable
        public Channel getChannel(RabbitResourceHolder holder) {
            return holder.getChannel();
        }

        @Override
        @Nullable
        public Connection getConnection(RabbitResourceHolder holder) {
            return holder.getConnection();
        }

        @Override
        public Connection createConnection() {
            return ConnectionFactoryUtils.createConnection(this.connectionFactory, this.publisherConnectionIfPossible);
        }

        @Override
        public Channel createChannel(Connection con) {
            return con.createChannel(this.synchedLocalTransactionAllowed);
        }

        @Override
        public boolean isSynchedLocalTransactionAllowed() {
            return this.synchedLocalTransactionAllowed;
        }
    }

    public static interface ResourceFactory {
        @Nullable
        public Channel getChannel(RabbitResourceHolder var1);

        public Connection getConnection(RabbitResourceHolder var1);

        public Connection createConnection() throws IOException;

        public Channel createChannel(Connection var1) throws IOException;

        public boolean isSynchedLocalTransactionAllowed();
    }

    private static final class RabbitResourceSynchronization
    extends ResourceHolderSynchronization<RabbitResourceHolder, Object> {
        private final RabbitResourceHolder resourceHolder;
        private final Consumer<AfterCompletionFailedException> afterCompletionCallback;

        RabbitResourceSynchronization(RabbitResourceHolder resourceHolder, Object resourceKey, Consumer<AfterCompletionFailedException> afterCompletionCallback) {
            super((ResourceHolder)resourceHolder, resourceKey);
            this.resourceHolder = resourceHolder;
            this.afterCompletionCallback = afterCompletionCallback;
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        public void afterCompletion(int status) {
            try {
                if (status == 0) {
                    this.resourceHolder.commitAll();
                } else {
                    this.resourceHolder.rollbackAll();
                }
            }
            catch (RuntimeException ex) {
                this.afterCompletionCallback.accept(new AfterCompletionFailedException(status, ex));
            }
            finally {
                if (this.resourceHolder.isReleaseAfterCompletion()) {
                    this.resourceHolder.setSynchronizedWithTransaction(false);
                }
                super.afterCompletion(status);
            }
        }

        protected void releaseResource(RabbitResourceHolder resourceHolder, Object resourceKey) {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
        }
    }
}

