/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.adapter.ReplyFailureException;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.amqp.support.converter.RemoteInvocationResult;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.TypeUtils;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener {
    private HandlerAdapter handlerAdapter;
    private final MessagingMessageConverterAdapter messagingMessageConverter;
    private final boolean returnExceptions;
    private final RabbitListenerErrorHandler errorHandler;

    public MessagingMessageListenerAdapter() {
        this(null, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method) {
        this(bean, method, false, null);
    }

    public MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler) {
        this(bean, method, returnExceptions, errorHandler, false);
    }

    protected MessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler, boolean batch) {
        this.messagingMessageConverter = new MessagingMessageConverterAdapter(bean, method, batch);
        this.returnExceptions = returnExceptions;
        this.errorHandler = errorHandler;
    }

    public void setHandlerAdapter(HandlerAdapter handlerAdapter) {
        this.handlerAdapter = handlerAdapter;
    }

    protected HandlerAdapter getHandlerAdapter() {
        return this.handlerAdapter;
    }

    public boolean isAsyncReplies() {
        return this.handlerAdapter.isAsyncReplies();
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"HeaderMapper must not be null");
        this.messagingMessageConverter.setHeaderMapper(headerMapper);
    }

    protected final MessagingMessageConverter getMessagingMessageConverter() {
        return this.messagingMessageConverter;
    }

    @Override
    public void setMessageConverter(MessageConverter messageConverter) {
        super.setMessageConverter(messageConverter);
        this.messagingMessageConverter.setPayloadConverter(messageConverter);
    }

    @Override
    public void onMessage(org.springframework.amqp.core.Message amqpMessage, Channel channel) throws Exception {
        Message<?> message = null;
        try {
            message = this.toMessagingMessage(amqpMessage);
            this.invokeHandlerAndProcessResult(amqpMessage, channel, message);
        }
        catch (ListenerExecutionFailedException ex) {
            this.handleException(amqpMessage, channel, message, ex);
        }
        catch (ReplyFailureException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.handleException(amqpMessage, channel, message, new ListenerExecutionFailedException("Failed to convert message", ex, amqpMessage));
        }
    }

    @Override
    protected void asyncFailure(org.springframework.amqp.core.Message request, Channel channel, Throwable t, Object source) {
        try {
            this.handleException(request, channel, (Message)source, new ListenerExecutionFailedException("Async Fail", t, request));
            return;
        }
        catch (Exception exception) {
            super.asyncFailure(request, channel, t, source);
            return;
        }
    }

    private void handleException(org.springframework.amqp.core.Message amqpMessage, Channel channel, @Nullable Message<?> message, ListenerExecutionFailedException e) throws Exception {
        block6: {
            if (this.errorHandler != null) {
                try {
                    Object errorResult;
                    Message messageWithChannel = null;
                    if (message != null) {
                        messageWithChannel = MessageBuilder.fromMessage(message).setHeader("amqp_channel", (Object)channel).build();
                    }
                    if ((errorResult = this.errorHandler.handleError(amqpMessage, channel, messageWithChannel, e)) != null) {
                        Object payload = message == null ? null : message.getPayload();
                        InvocationResult invResult = payload == null ? new InvocationResult(errorResult, null, null, null, null) : this.handlerAdapter.getInvocationResultFor(errorResult, payload);
                        this.handleResult(invResult, amqpMessage, channel, message);
                        break block6;
                    }
                    this.logger.trace((Object)"Error handler returned no result");
                }
                catch (Exception ex) {
                    this.returnOrThrow(amqpMessage, channel, message, ex, ex);
                }
            } else {
                this.returnOrThrow(amqpMessage, channel, message, e.getCause(), (Exception)((Object)e));
            }
        }
    }

    protected void invokeHandlerAndProcessResult(@Nullable org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) throws Exception {
        boolean projectionUsed;
        boolean bl = projectionUsed = amqpMessage == null ? false : amqpMessage.getMessageProperties().isProjectionUsed();
        if (projectionUsed) {
            amqpMessage.getMessageProperties().setProjectionUsed(false);
        }
        if (this.logger.isDebugEnabled() && !projectionUsed) {
            this.logger.debug((Object)("Processing [" + String.valueOf(message) + "]"));
        }
        InvocationResult result = null;
        if (this.messagingMessageConverter.method == null && amqpMessage != null) {
            amqpMessage.getMessageProperties().setTargetMethod(this.handlerAdapter.getMethodFor(message.getPayload()));
        }
        if ((result = this.invokeHandler(amqpMessage, channel, message)).getReturnValue() != null) {
            this.handleResult(result, amqpMessage, channel, message);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    private void returnOrThrow(org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message, Throwable throwableToReturn, Exception exceptionToThrow) throws Exception {
        if (!this.returnExceptions) {
            throw exceptionToThrow;
        }
        Object payload = message == null ? null : message.getPayload();
        try {
            this.handleResult(new InvocationResult(new RemoteInvocationResult(throwableToReturn), null, (Type)(payload == null ? Object.class : this.handlerAdapter.getReturnTypeFor(payload)), this.handlerAdapter.getBean(), payload == null ? null : this.handlerAdapter.getMethodFor(payload)), amqpMessage, channel, message);
        }
        catch (ReplyFailureException rfe) {
            if (payload == null || Void.TYPE.equals(this.handlerAdapter.getReturnTypeFor(payload))) {
                throw exceptionToThrow;
            }
            throw rfe;
        }
    }

    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        return (Message)this.getMessagingMessageConverter().fromMessage(amqpMessage);
    }

    private InvocationResult invokeHandler(@Nullable org.springframework.amqp.core.Message amqpMessage, Channel channel, Message<?> message) {
        try {
            if (amqpMessage == null) {
                return this.handlerAdapter.invoke(message, channel);
            }
            return this.handlerAdapter.invoke(message, amqpMessage, channel, amqpMessage.getMessageProperties());
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with the incoming message", message.getPayload()), ex, amqpMessage);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + this.handlerAdapter.getMethodAsString(message.getPayload()) + "' threw exception", ex, amqpMessage);
        }
    }

    private String createMessagingErrorMessage(String description, Object payload) {
        return description + "\nEndpoint handler details:\nMethod [" + this.handlerAdapter.getMethodAsString(payload) + "]\nBean [" + String.valueOf(this.handlerAdapter.getBean()) + "]";
    }

    @Override
    protected org.springframework.amqp.core.Message buildMessage(Channel channel, Object result, Type genericType) {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null && !(result instanceof org.springframework.amqp.core.Message)) {
            if (result instanceof Message) {
                return this.messagingMessageConverter.toMessage(result, new MessageProperties());
            }
            return this.convert(result, genericType, converter);
        }
        if (result instanceof org.springframework.amqp.core.Message) {
            org.springframework.amqp.core.Message msg = (org.springframework.amqp.core.Message)result;
            return msg;
        }
        throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + String.valueOf(result) + "]");
    }

    protected final class MessagingMessageConverterAdapter
    extends MessagingMessageConverter {
        private final Object bean;
        final Method method;
        private final Type inferredArgumentType;
        private final boolean isBatch;
        private boolean isMessageList;
        private boolean isAmqpMessageList;
        private boolean isCollection;

        MessagingMessageConverterAdapter(Object bean, Method method, boolean batch) {
            this.bean = bean;
            this.method = method;
            this.isBatch = batch;
            this.inferredArgumentType = this.determineInferredType();
            if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled() && this.inferredArgumentType != null) {
                MessagingMessageListenerAdapter.this.logger.debug((Object)("Inferred argument type for " + method.toString() + " is " + String.valueOf(this.inferredArgumentType)));
            }
        }

        protected boolean isMessageList() {
            return this.isMessageList;
        }

        protected boolean isAmqpMessageList() {
            return this.isAmqpMessageList;
        }

        protected Method getMethod() {
            return this.method;
        }

        protected Object extractPayload(org.springframework.amqp.core.Message message) {
            MessageProperties messageProperties = message.getMessageProperties();
            if (this.bean != null) {
                messageProperties.setTargetBean(this.bean);
            }
            if (this.method != null) {
                messageProperties.setTargetMethod(this.method);
                if (this.inferredArgumentType != null) {
                    messageProperties.setInferredArgumentType(this.inferredArgumentType);
                }
            }
            return MessagingMessageListenerAdapter.this.extractMessage(message);
        }

        private Type determineInferredType() {
            if (this.method == null) {
                return null;
            }
            Type genericParameterType = null;
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                MethodParameter methodParameter = new MethodParameter(this.method, i);
                boolean isHeaderOrHeaders = methodParameter.hasParameterAnnotation(Header.class) || methodParameter.hasParameterAnnotation(Headers.class) || methodParameter.getParameterType().equals(MessageHeaders.class);
                boolean isPayload = methodParameter.hasParameterAnnotation(Payload.class);
                if (isHeaderOrHeaders && isPayload && MessagingMessageListenerAdapter.this.logger.isWarnEnabled()) {
                    MessagingMessageListenerAdapter.this.logger.warn((Object)(this.method.getName() + ": Cannot annotate a parameter with both @Header and @Payload; ignored for payload conversion"));
                }
                if (!this.isEligibleParameter(methodParameter) || isHeaderOrHeaders && !isPayload || isHeaderOrHeaders && isPayload) continue;
                if (genericParameterType == null) {
                    genericParameterType = this.extractGenericParameterTypFromMethodParameter(methodParameter);
                    if (!this.isBatch || this.isCollection) continue;
                    throw new IllegalStateException("Mis-configuration; a batch listener must consume a List<?> or Collection<?> for method: " + String.valueOf(this.method));
                }
                if (MessagingMessageListenerAdapter.this.logger.isDebugEnabled()) {
                    MessagingMessageListenerAdapter.this.logger.debug((Object)("Ambiguous parameters for target payload for method " + String.valueOf(this.method) + "; no inferred type header added"));
                }
                return null;
            }
            return this.checkOptional(genericParameterType);
        }

        protected Type checkOptional(Type genericParameterType) {
            ParameterizedType pType;
            if (genericParameterType instanceof ParameterizedType && (pType = (ParameterizedType)genericParameterType).getRawType().equals(Optional.class)) {
                return pType.getActualTypeArguments()[0];
            }
            return genericParameterType;
        }

        private boolean isEligibleParameter(MethodParameter methodParameter) {
            ParameterizedType parameterizedType;
            Type parameterType = methodParameter.getGenericParameterType();
            if (parameterType.equals(Channel.class) || parameterType.equals(MessageProperties.class) || parameterType.equals(org.springframework.amqp.core.Message.class) || parameterType.getTypeName().startsWith("kotlin.coroutines.Continuation")) {
                return false;
            }
            if (parameterType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)parameterType).getRawType().equals(Message.class)) {
                return !(parameterizedType.getActualTypeArguments()[0] instanceof WildcardType);
            }
            return !parameterType.equals(Message.class);
        }

        private Type extractGenericParameterTypFromMethodParameter(MethodParameter methodParameter) {
            Type genericParameterType = methodParameter.getGenericParameterType();
            if (genericParameterType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericParameterType;
                if (parameterizedType.getRawType().equals(Message.class)) {
                    genericParameterType = ((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                } else if (this.isBatch && (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Collection.class)) && parameterizedType.getActualTypeArguments().length == 1) {
                    ParameterizedType pType;
                    this.isCollection = true;
                    Type paramType = parameterizedType.getActualTypeArguments()[0];
                    boolean messageHasGeneric = paramType instanceof ParameterizedType && (pType = (ParameterizedType)paramType).getRawType().equals(Message.class);
                    this.isMessageList = TypeUtils.isAssignable((Type)paramType, Message.class) || messageHasGeneric;
                    this.isAmqpMessageList = TypeUtils.isAssignable((Type)paramType, org.springframework.amqp.core.Message.class);
                    genericParameterType = messageHasGeneric ? ((ParameterizedType)paramType).getActualTypeArguments()[0] : paramType;
                }
            }
            return genericParameterType;
        }
    }
}

