/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.rabbit.connection.NodeLocator;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriUtils;

public class WebFluxNodeLocator
implements NodeLocator<WebClient> {
    @Override
    @Nullable
    public Map<String, Object> restCall(WebClient client, String baseUri, String vhost, String queue) throws URISyntaxException {
        URI uri = new URI(baseUri).resolve("/api/queues/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + queue);
        HashMap queueInfo = (HashMap)client.get().uri(uri).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().bodyToMono((ParameterizedTypeReference)new ParameterizedTypeReference<HashMap<String, Object>>(){}).block(Duration.ofSeconds(10L));
        return queueInfo != null ? queueInfo : null;
    }

    @Override
    public WebClient createClient(String username, String password) {
        return WebClient.builder().filter(ExchangeFilterFunctions.basicAuthentication((String)username, (String)password)).build();
    }
}

