/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.mockito;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.internal.stubbing.defaultanswers.ForwardsInvocations;
import org.mockito.invocation.InvocationOnMock;
import org.springframework.lang.Nullable;

public class LambdaAnswer<T>
extends ForwardsInvocations {
    private final boolean callRealMethod;
    private final ValueToReturn<T> callback;
    private final Set<Exception> exceptions = Collections.synchronizedSet(new LinkedHashSet());
    private final boolean hasDelegate;

    @Deprecated
    public LambdaAnswer(boolean callRealMethod, ValueToReturn<T> callback) {
        this(callRealMethod, callback, null);
    }

    public LambdaAnswer(boolean callRealMethod, ValueToReturn<T> callback, @Nullable Object delegate) {
        super(delegate);
        this.callRealMethod = callRealMethod;
        this.callback = callback;
        this.hasDelegate = delegate != null;
    }

    public T answer(InvocationOnMock invocation) throws Throwable {
        Object result = null;
        try {
            if (this.callRealMethod) {
                result = this.hasDelegate ? super.answer(invocation) : invocation.callRealMethod();
            }
            return this.callback.apply(invocation, result);
        }
        catch (Exception e) {
            this.exceptions.add(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Exception> getExceptions() {
        Set<Exception> set = this.exceptions;
        synchronized (set) {
            return new LinkedHashSet<Exception>(this.exceptions);
        }
    }

    @FunctionalInterface
    public static interface ValueToReturn<T> {
        public T apply(InvocationOnMock var1, T var2);
    }
}

