/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.rabbit.stream.micrometer.RabbitStreamListenerObservationConvention;
import org.springframework.rabbit.stream.micrometer.RabbitStreamMessageReceiverContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RabbitStreamListenerObservation implements ObservationDocumentation
{
    STREAM_LISTENER_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultRabbitStreamListenerObservationConvention.class;
        }

        public String getPrefix() {
            return "spring.rabbit.stream.listener";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return ListenerLowCardinalityTags.values();
        }
    };


    public static class DefaultRabbitStreamListenerObservationConvention
    implements RabbitStreamListenerObservationConvention {
        public static final DefaultRabbitStreamListenerObservationConvention INSTANCE = new DefaultRabbitStreamListenerObservationConvention();

        public KeyValues getLowCardinalityKeyValues(RabbitStreamMessageReceiverContext context) {
            return KeyValues.of((String)ListenerLowCardinalityTags.LISTENER_ID.asString(), (String)context.getListenerId());
        }

        public String getContextualName(RabbitStreamMessageReceiverContext context) {
            return context.getSource() + " receive";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerLowCardinalityTags implements KeyName
    {
        LISTENER_ID{

            public String asString() {
                return "spring.rabbit.stream.listener.id";
            }
        };

    }
}

