/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.support.converter;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.Properties;
import com.rabbitmq.stream.codec.WrapperMessageBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.lang.Nullable;
import org.springframework.rabbit.stream.support.StreamMessageProperties;
import org.springframework.rabbit.stream.support.converter.StreamMessageConverter;
import org.springframework.util.Assert;

public class DefaultStreamMessageConverter
implements StreamMessageConverter {
    private final Charset charset = StandardCharsets.UTF_8;
    private Supplier<MessageBuilder> builderSupplier;

    public DefaultStreamMessageConverter() {
        this.builderSupplier = () -> new WrapperMessageBuilder();
    }

    public DefaultStreamMessageConverter(@Nullable Codec codec) {
        this.builderSupplier = () -> codec.messageBuilder();
    }

    public void setBuilderSupplier(Supplier<MessageBuilder> builderSupplier) {
        this.builderSupplier = builderSupplier;
    }

    @Override
    public org.springframework.amqp.core.Message toMessage(Object object, StreamMessageProperties messageProperties) throws MessageConversionException {
        Assert.isInstanceOf(Message.class, (Object)object);
        Message streamMessage = (Message)object;
        this.toMessageProperties(streamMessage, messageProperties);
        return org.springframework.amqp.core.MessageBuilder.withBody((byte[])streamMessage.getBodyAsBinary()).andProperties((MessageProperties)messageProperties).build();
    }

    @Override
    public Message fromMessage(org.springframework.amqp.core.Message message) throws MessageConversionException {
        MessageBuilder builder = this.builderSupplier.get();
        MessageBuilder.PropertiesBuilder propsBuilder = builder.properties();
        MessageProperties props = message.getMessageProperties();
        Assert.isInstanceOf(StreamMessageProperties.class, (Object)props);
        StreamMessageProperties mProps = (StreamMessageProperties)props;
        JavaUtils.INSTANCE.acceptIfNotNull((Object)mProps.getMessageId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).messageId(arg_0)).acceptIfNotNull((Object)mProps.getUserId(), usr -> propsBuilder.userId(usr.getBytes(this.charset))).acceptIfNotNull((Object)mProps.getTo(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).to(arg_0)).acceptIfNotNull((Object)mProps.getSubject(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).subject(arg_0)).acceptIfNotNull((Object)mProps.getReplyTo(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).replyTo(arg_0)).acceptIfNotNull((Object)mProps.getCorrelationId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).correlationId(arg_0)).acceptIfNotNull((Object)mProps.getContentType(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).contentType(arg_0)).acceptIfNotNull((Object)mProps.getContentEncoding(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).contentEncoding(arg_0)).acceptIfNotNull((Object)mProps.getExpiration(), exp -> propsBuilder.absoluteExpiryTime(Long.parseLong(exp))).acceptIfNotNull((Object)mProps.getCreationTime(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).creationTime(arg_0)).acceptIfNotNull((Object)mProps.getGroupId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).groupId(arg_0)).acceptIfNotNull((Object)mProps.getGroupSequence(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).groupSequence(arg_0)).acceptIfNotNull((Object)mProps.getReplyToGroupId(), arg_0 -> ((MessageBuilder.PropertiesBuilder)propsBuilder).replyToGroupId(arg_0));
        MessageBuilder.ApplicationPropertiesBuilder appPropsBuilder = builder.applicationProperties();
        if (mProps.getHeaders().size() > 0) {
            mProps.getHeaders().forEach((key, val) -> this.mapProp((String)key, val, appPropsBuilder));
        }
        builder.addData(message.getBody());
        return builder.build();
    }

    private void mapProp(String key, Object val, MessageBuilder.ApplicationPropertiesBuilder builder) {
        if (val instanceof String) {
            builder.entry(key, (String)val);
        } else if (val instanceof Long) {
            builder.entry(key, ((Long)val).longValue());
        } else if (val instanceof Integer) {
            builder.entry(key, ((Integer)val).intValue());
        } else if (val instanceof Short) {
            builder.entry(key, ((Short)val).shortValue());
        } else if (val instanceof Byte) {
            builder.entry(key, ((Byte)val).byteValue());
        } else if (val instanceof Double) {
            builder.entry(key, ((Double)val).doubleValue());
        } else if (val instanceof Float) {
            builder.entry(key, ((Float)val).floatValue());
        } else if (val instanceof Character) {
            builder.entry(key, ((Character)val).charValue());
        } else if (val instanceof UUID) {
            builder.entry(key, (UUID)val);
        } else if (val instanceof byte[]) {
            builder.entry(key, (byte[])val);
        }
    }

    private void toMessageProperties(Message streamMessage, StreamMessageProperties mProps) {
        Map applicationProperties;
        Properties properties = streamMessage.getProperties();
        if (properties != null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)properties.getMessageIdAsString(), arg_0 -> ((StreamMessageProperties)mProps).setMessageId(arg_0)).acceptIfNotNull((Object)properties.getUserId(), usr -> mProps.setUserId(new String((byte[])usr, this.charset))).acceptIfNotNull((Object)properties.getTo(), mProps::setTo).acceptIfNotNull((Object)properties.getSubject(), mProps::setSubject).acceptIfNotNull((Object)properties.getReplyTo(), arg_0 -> ((StreamMessageProperties)mProps).setReplyTo(arg_0)).acceptIfNotNull((Object)properties.getCorrelationIdAsString(), arg_0 -> ((StreamMessageProperties)mProps).setCorrelationId(arg_0)).acceptIfNotNull((Object)properties.getContentType(), arg_0 -> ((StreamMessageProperties)mProps).setContentType(arg_0)).acceptIfNotNull((Object)properties.getContentEncoding(), arg_0 -> ((StreamMessageProperties)mProps).setContentEncoding(arg_0)).acceptIfNotNull((Object)properties.getAbsoluteExpiryTime(), exp -> mProps.setExpiration(Long.toString(exp))).acceptIfNotNull((Object)properties.getCreationTime(), mProps::setCreationTime).acceptIfNotNull((Object)properties.getGroupId(), mProps::setGroupId).acceptIfNotNull((Object)properties.getGroupSequence(), mProps::setGroupSequence).acceptIfNotNull((Object)properties.getReplyToGroupId(), mProps::setReplyToGroupId);
        }
        if ((applicationProperties = streamMessage.getApplicationProperties()) != null) {
            mProps.getHeaders().putAll(applicationProperties);
        }
    }
}

