/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.junit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.amqp.rabbit.junit.JUnitUtils;

public class LogLevelAdjuster
implements MethodRule {
    private final List<Class<?>> classes;
    private List<String> categories;
    private final Level level;

    public LogLevelAdjuster(Level level, Class<?> ... classes) {
        this.level = level;
        this.classes = new ArrayList(Arrays.asList(classes));
        this.classes.add(this.getClass());
        this.categories = Collections.emptyList();
    }

    public LogLevelAdjuster categories(String ... categoriesToAdjust) {
        this.categories = new ArrayList<String>(Arrays.asList(categoriesToAdjust));
        return this;
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(this){
            final /* synthetic */ LogLevelAdjuster this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void evaluate() throws Throwable {
                JUnitUtils.LevelsContainer container = null;
                try {
                    container = JUnitUtils.adjustLogLevels(method.getName(), this.this$0.classes, this.this$0.categories, this.this$0.level);
                    base.evaluate();
                    if (container == null) return;
                }
                catch (Throwable throwable) {
                    if (container == null) throw throwable;
                    JUnitUtils.revertLevels(method.getName(), container);
                    throw throwable;
                }
                JUnitUtils.revertLevels(method.getName(), container);
            }
        };
    }
}

