/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.lang.reflect.Type;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;

public abstract class AbstractMessageConverter
implements MessageConverter {
    private boolean createMessageIds = false;

    public void setCreateMessageIds(boolean createMessageIds) {
        this.createMessageIds = createMessageIds;
    }

    protected boolean isCreateMessageIds() {
        return this.createMessageIds;
    }

    @Override
    public final Message toMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        return this.toMessage(object, messageProperties, null);
    }

    @Override
    public final Message toMessage(Object object, @Nullable MessageProperties messagePropertiesArg, @Nullable Type genericType) throws MessageConversionException {
        MessageProperties messageProperties = messagePropertiesArg;
        if (messageProperties == null) {
            messageProperties = new MessageProperties();
        }
        Message message = this.createMessage(object, messageProperties, genericType);
        messageProperties = message.getMessageProperties();
        if (this.createMessageIds && messageProperties.getMessageId() == null) {
            messageProperties.setMessageId(UUID.randomUUID().toString());
        }
        return message;
    }

    protected Message createMessage(Object object, MessageProperties messageProperties, @Nullable Type genericType) {
        return this.createMessage(object, messageProperties);
    }

    protected abstract Message createMessage(Object var1, MessageProperties var2);
}

