/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.support.converter.RemoteInvocationUtils;

public class RemoteInvocationResult
implements Serializable {
    private static final long serialVersionUID = 2138555143707773549L;
    private transient @Nullable Object value;
    private @Nullable Throwable exception;

    public RemoteInvocationResult(@Nullable Object value) {
        this.value = value;
    }

    public RemoteInvocationResult(@Nullable Throwable exception) {
        this.exception = exception;
    }

    public RemoteInvocationResult() {
    }

    public void setValue(@Nullable Object value) {
        this.value = value;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public void setException(@Nullable Throwable exception) {
        this.exception = exception;
    }

    public @Nullable Throwable getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public boolean hasInvocationTargetException() {
        return this.exception instanceof InvocationTargetException;
    }

    public @Nullable Object recreate() throws Throwable {
        if (this.exception != null) {
            Throwable throwable;
            Throwable throwable2 = this.exception;
            if (throwable2 instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)throwable2;
                throwable = invocationTargetException.getTargetException();
            } else {
                throwable = this.exception;
            }
            Throwable exToThrow = throwable;
            RemoteInvocationUtils.fillInClientStackTraceIfPossible(exToThrow);
            throw exToThrow;
        }
        return this.value;
    }
}

