/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Date;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.beans.BeanUtils;

public abstract class MessageBuilderSupport<T> {
    private MessageProperties properties = new MessageProperties();

    protected MessageBuilderSupport() {
    }

    protected MessageBuilderSupport(MessageProperties properties) {
        this.properties = properties;
    }

    protected void setProperties(MessageProperties properties) {
        this.properties = properties;
    }

    public MessageBuilderSupport<T> setHeader(String key, Object value) {
        this.properties.setHeader(key, value);
        return this;
    }

    public MessageBuilderSupport<T> setTimestamp(Date timestamp) {
        this.properties.setTimestamp(timestamp);
        return this;
    }

    public MessageBuilderSupport<T> setMessageId(String messageId) {
        this.properties.setMessageId(messageId);
        return this;
    }

    public MessageBuilderSupport<T> setUserId(String userId) {
        this.properties.setUserId(userId);
        return this;
    }

    public MessageBuilderSupport<T> setAppId(String appId) {
        this.properties.setAppId(appId);
        return this;
    }

    public MessageBuilderSupport<T> setClusterId(String clusterId) {
        this.properties.setClusterId(clusterId);
        return this;
    }

    public MessageBuilderSupport<T> setType(String type) {
        this.properties.setType(type);
        return this;
    }

    public MessageBuilderSupport<T> setCorrelationId(String correlationId) {
        this.properties.setCorrelationId(correlationId);
        return this;
    }

    public MessageBuilderSupport<T> setReplyTo(String replyTo) {
        this.properties.setReplyTo(replyTo);
        return this;
    }

    public MessageBuilderSupport<T> setReplyToAddress(Address replyTo) {
        this.properties.setReplyToAddress(replyTo);
        return this;
    }

    public MessageBuilderSupport<T> setContentType(String contentType) {
        this.properties.setContentType(contentType);
        return this;
    }

    public MessageBuilderSupport<T> setContentEncoding(String contentEncoding) {
        this.properties.setContentEncoding(contentEncoding);
        return this;
    }

    public MessageBuilderSupport<T> setContentLength(long contentLength) {
        this.properties.setContentLength(contentLength);
        return this;
    }

    public MessageBuilderSupport<T> setDeliveryMode(MessageDeliveryMode deliveryMode) {
        this.properties.setDeliveryMode(deliveryMode);
        return this;
    }

    public MessageBuilderSupport<T> setExpiration(String expiration) {
        this.properties.setExpiration(expiration);
        return this;
    }

    public MessageBuilderSupport<T> setPriority(Integer priority) {
        this.properties.setPriority(priority);
        return this;
    }

    public MessageBuilderSupport<T> setReceivedExchange(String receivedExchange) {
        this.properties.setReceivedExchange(receivedExchange);
        return this;
    }

    public MessageBuilderSupport<T> setReceivedRoutingKey(String receivedRoutingKey) {
        this.properties.setReceivedRoutingKey(receivedRoutingKey);
        return this;
    }

    public MessageBuilderSupport<T> setRedelivered(Boolean redelivered) {
        this.properties.setRedelivered(redelivered);
        return this;
    }

    public MessageBuilderSupport<T> setDeliveryTag(Long deliveryTag) {
        this.properties.setDeliveryTag(deliveryTag);
        return this;
    }

    public MessageBuilderSupport<T> setMessageCount(Integer messageCount) {
        this.properties.setMessageCount(messageCount);
        return this;
    }

    public MessageBuilderSupport<T> setHeaderIfAbsent(String key, Object value) {
        if (this.properties.getHeaders().get(key) == null) {
            this.properties.setHeader(key, value);
        }
        return this;
    }

    public MessageBuilderSupport<T> setTimestampIfAbsent(Date timestamp) {
        if (this.properties.getTimestamp() == null) {
            this.properties.setTimestamp(timestamp);
        }
        return this;
    }

    public MessageBuilderSupport<T> setMessageIdIfAbsent(String messageId) {
        if (this.properties.getMessageId() == null) {
            this.properties.setMessageId(messageId);
        }
        return this;
    }

    public MessageBuilderSupport<T> setUserIdIfAbsent(String userId) {
        if (this.properties.getUserId() == null) {
            this.properties.setUserId(userId);
        }
        return this;
    }

    public MessageBuilderSupport<T> setAppIdIfAbsent(String appId) {
        if (this.properties.getAppId() == null) {
            this.properties.setAppId(appId);
        }
        return this;
    }

    public MessageBuilderSupport<T> setClusterIdIfAbsent(String clusterId) {
        if (this.properties.getClusterId() == null) {
            this.properties.setClusterId(clusterId);
        }
        return this;
    }

    public MessageBuilderSupport<T> setTypeIfAbsent(String type) {
        if (this.properties.getType() == null) {
            this.properties.setType(type);
        }
        return this;
    }

    public MessageBuilderSupport<T> setCorrelationIdIfAbsent(String correlationId) {
        if (this.properties.getCorrelationId() == null) {
            this.properties.setCorrelationId(correlationId);
        }
        return this;
    }

    public MessageBuilderSupport<T> setReplyToIfAbsent(String replyTo) {
        if (this.properties.getReplyTo() == null) {
            this.properties.setReplyTo(replyTo);
        }
        return this;
    }

    public MessageBuilderSupport<T> setReplyToAddressIfAbsent(Address replyTo) {
        if (this.properties.getReplyToAddress() == null) {
            this.properties.setReplyToAddress(replyTo);
        }
        return this;
    }

    public MessageBuilderSupport<T> setContentTypeIfAbsentOrDefault(String contentType) {
        if (this.properties.getContentType() == null || this.properties.getContentType().equals("application/octet-stream")) {
            this.properties.setContentType(contentType);
        }
        return this;
    }

    public MessageBuilderSupport<T> setContentEncodingIfAbsent(String contentEncoding) {
        if (this.properties.getContentEncoding() == null) {
            this.properties.setContentEncoding(contentEncoding);
        }
        return this;
    }

    public MessageBuilderSupport<T> setContentLengthIfAbsent(long contentLength) {
        if (!this.properties.isContentLengthSet()) {
            this.properties.setContentLength(contentLength);
        }
        return this;
    }

    public MessageBuilderSupport<T> setDeliveryModeIfAbsentOrDefault(MessageDeliveryMode deliveryMode) {
        if (this.properties.getDeliveryMode() == null || this.properties.getDeliveryMode().equals((Object)MessageProperties.DEFAULT_DELIVERY_MODE)) {
            this.properties.setDeliveryMode(deliveryMode);
        }
        return this;
    }

    public MessageBuilderSupport<T> setExpirationIfAbsent(String expiration) {
        if (this.properties.getExpiration() == null) {
            this.properties.setExpiration(expiration);
        }
        return this;
    }

    public MessageBuilderSupport<T> setPriorityIfAbsentOrDefault(Integer priority) {
        if (this.properties.getPriority() == null || MessageProperties.DEFAULT_PRIORITY.equals(this.properties.getPriority())) {
            this.properties.setPriority(priority);
        }
        return this;
    }

    public MessageBuilderSupport<T> setReceivedExchangeIfAbsent(String receivedExchange) {
        if (this.properties.getReceivedExchange() == null) {
            this.properties.setReceivedExchange(receivedExchange);
        }
        return this;
    }

    public MessageBuilderSupport<T> setReceivedRoutingKeyIfAbsent(String receivedRoutingKey) {
        if (this.properties.getReceivedRoutingKey() == null) {
            this.properties.setReceivedRoutingKey(receivedRoutingKey);
        }
        return this;
    }

    public MessageBuilderSupport<T> setRedeliveredIfAbsent(Boolean redelivered) {
        if (this.properties.isRedelivered() == null) {
            this.properties.setRedelivered(redelivered);
        }
        return this;
    }

    public MessageBuilderSupport<T> setDeliveryTagIfAbsent(Long deliveryTag) {
        if (!this.properties.isDeliveryTagSet()) {
            this.properties.setDeliveryTag(deliveryTag);
        }
        return this;
    }

    public MessageBuilderSupport<T> setMessageCountIfAbsent(Integer messageCount) {
        if (this.properties.getMessageCount() == null) {
            this.properties.setMessageCount(messageCount);
        }
        return this;
    }

    public MessageBuilderSupport<T> copyProperties(MessageProperties properties) {
        BeanUtils.copyProperties((Object)properties, (Object)this.properties);
        this.properties.setReplyTo(properties.getReplyTo());
        this.properties.getHeaders().putAll(properties.getHeaders());
        return this;
    }

    public MessageBuilderSupport<T> copyHeaders(Map<String, Object> headers) {
        this.properties.getHeaders().putAll(headers);
        return this;
    }

    public MessageBuilderSupport<T> copyHeadersIfAbsent(Map<String, Object> headers) {
        Map<String, @Nullable Object> existingHeaders = this.properties.getHeaders();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (existingHeaders.containsKey(entry.getKey())) continue;
            existingHeaders.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public MessageBuilderSupport<T> removeHeader(String key) {
        this.properties.getHeaders().remove(key);
        return this;
    }

    public MessageBuilderSupport<T> removeHeaders() {
        this.properties.getHeaders().clear();
        return this;
    }

    protected MessageProperties buildProperties() {
        return this.properties;
    }

    public abstract T build();
}

