/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AllowedListDeserializingMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.utils.SerializationUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SimpleMessageConverter
extends AllowedListDeserializingMessageConverter
implements BeanClassLoaderAware {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String defaultCharset = "UTF-8";
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public void setDefaultCharset(@Nullable String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        if (properties != null) {
            String contentType = properties.getContentType();
            if (contentType != null && contentType.startsWith("text")) {
                String encoding = properties.getContentEncoding();
                if (encoding == null) {
                    encoding = this.defaultCharset;
                }
                try {
                    content = new String(message.getBody(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessageConversionException("failed to convert text-based Message content", e);
                }
            }
            if (contentType != null && contentType.equals("application/x-java-serialized-object")) {
                try {
                    content = SerializationUtils.deserialize(this.createObjectInputStream(new ByteArrayInputStream(message.getBody())));
                }
                catch (IOException | IllegalArgumentException | IllegalStateException e) {
                    throw new MessageConversionException("failed to convert serialized Message content", e);
                }
            }
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    @Override
    protected Message createMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes = null;
        if (object instanceof byte[]) {
            byte[] objectBytes;
            bytes = objectBytes = (byte[])object;
            messageProperties.setContentType("application/octet-stream");
        } else if (object instanceof String) {
            String string = (String)object;
            try {
                bytes = string.getBytes(this.defaultCharset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageConversionException("failed to convert to Message content", e);
            }
            messageProperties.setContentType("text/plain");
            messageProperties.setContentEncoding(this.defaultCharset);
        } else if (object instanceof Serializable) {
            try {
                bytes = SerializationUtils.serialize(object);
            }
            catch (IllegalArgumentException e) {
                throw new MessageConversionException("failed to convert to serialized Message content", e);
            }
            messageProperties.setContentType("application/x-java-serialized-object");
        }
        if (bytes != null) {
            messageProperties.setContentLength(bytes.length);
            return new Message(bytes, messageProperties);
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " only supports String, byte[] and Serializable payloads, received: " + object.getClass().getName());
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ConfigurableObjectInputStream(is, this.classLoader){

            protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
                Class clazz = super.resolveClass(classDesc);
                SimpleMessageConverter.this.checkAllowedList(clazz);
                return clazz;
            }
        };
    }
}

