/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class Address {
    public static final String AMQ_RABBITMQ_REPLY_TO = "amq.rabbitmq.reply-to";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^(?:.*://)?([^/]*)/?(.*)$");
    private final String exchangeName;
    private final String routingKey;

    public Address(String address) {
        if (!StringUtils.hasText((String)address)) {
            this.exchangeName = "";
            this.routingKey = "";
        } else if (address.startsWith(AMQ_RABBITMQ_REPLY_TO)) {
            this.routingKey = address;
            this.exchangeName = "";
        } else if (address.lastIndexOf(47) <= 0) {
            this.routingKey = address.replaceFirst("/", "");
            this.exchangeName = "";
        } else {
            Matcher matcher = ADDRESS_PATTERN.matcher(address);
            boolean matchFound = matcher.find();
            if (matchFound) {
                this.exchangeName = matcher.group(1);
                this.routingKey = matcher.group(2);
            } else {
                this.exchangeName = "";
                this.routingKey = address;
            }
        }
    }

    public Address(String exchangeName, String routingKey) {
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Address)) return false;
        Address address = (Address)o;
        if (!Objects.equals(this.exchangeName, address.exchangeName)) return false;
        if (!Objects.equals(this.routingKey, address.routingKey)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.exchangeName != null ? this.exchangeName.hashCode() : 0;
        int prime = 31;
        result = prime * result + (this.routingKey != null ? this.routingKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.exchangeName).append('/');
        if (StringUtils.hasText((String)this.routingKey)) {
            sb.append(this.routingKey);
        }
        return sb.toString();
    }
}

