/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import org.springframework.amqp.core.BaseExchangeBuilder;
import org.springframework.amqp.core.ConsistentHashExchange;

public class ExchangeBuilder
extends BaseExchangeBuilder<ExchangeBuilder> {
    public ExchangeBuilder(String name, String type) {
        super(name, type);
    }

    public static ExchangeBuilder directExchange(String name) {
        return new ExchangeBuilder(name, "direct");
    }

    public static ExchangeBuilder topicExchange(String name) {
        return new ExchangeBuilder(name, "topic");
    }

    public static ExchangeBuilder fanoutExchange(String name) {
        return new ExchangeBuilder(name, "fanout");
    }

    public static ExchangeBuilder headersExchange(String name) {
        return new ExchangeBuilder(name, "headers");
    }

    public static ConsistentHashExchangeBuilder consistentHashExchange(String name) {
        return new ConsistentHashExchangeBuilder(name);
    }

    public static final class ConsistentHashExchangeBuilder
    extends BaseExchangeBuilder<ConsistentHashExchangeBuilder> {
        public ConsistentHashExchangeBuilder(String name) {
            super(name, "x-consistent-hash");
        }

        public ConsistentHashExchangeBuilder hashHeader(String headerName) {
            this.withArgument("hash-header", headerName);
            return this;
        }

        public ConsistentHashExchangeBuilder hashProperty(String propertyName) {
            this.withArgument("hash-property", propertyName);
            return this;
        }

        @Override
        public ConsistentHashExchange build() {
            return this.configureExchange(new ConsistentHashExchange(this.name, this.durable, this.autoDelete, this.getArguments()));
        }
    }
}

