/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.content.Media;

public class ZhiPuAiAssistantMessage
extends AssistantMessage {
    private String reasoningContent;

    protected ZhiPuAiAssistantMessage(String content, String reasoningContent, Map<String, Object> properties, List<AssistantMessage.ToolCall> toolCalls, List<Media> media) {
        super(content, properties, toolCalls, media);
        this.reasoningContent = reasoningContent;
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public ZhiPuAiAssistantMessage setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ZhiPuAiAssistantMessage)) {
            return false;
        }
        ZhiPuAiAssistantMessage that = (ZhiPuAiAssistantMessage)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.reasoningContent, that.reasoningContent);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reasoningContent);
    }

    public String toString() {
        return "ZhiPuAiAssistantMessage{media=" + String.valueOf(this.media) + ", messageType=" + String.valueOf(this.messageType) + ", metadata=" + String.valueOf(this.metadata) + ", reasoningContent='" + this.reasoningContent + "', textContent='" + this.textContent + "'}";
    }

    public static final class Builder {
        private String content;
        private Map<String, Object> properties = Map.of();
        private List<AssistantMessage.ToolCall> toolCalls = List.of();
        private List<Media> media = List.of();
        private String reasoningContent;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder toolCalls(List<AssistantMessage.ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Builder media(List<Media> media) {
            this.media = media;
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public ZhiPuAiAssistantMessage build() {
            return new ZhiPuAiAssistantMessage(this.content, this.reasoningContent, this.properties, this.toolCalls, this.media);
        }
    }
}

