/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.zhipuai.ZhiPuAiEmbeddingOptions;
import org.springframework.ai.zhipuai.api.ZhiPuAiApi;
import org.springframework.ai.zhipuai.api.ZhiPuApiConstants;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ZhiPuAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(ZhiPuAiEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final ZhiPuAiEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final ZhiPuAiApi zhiPuAiApi;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi) {
        this(zhiPuAiApi, MetadataMode.EMBED);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode) {
        this(zhiPuAiApi, metadataMode, ZhiPuAiEmbeddingOptions.builder().model(ZhiPuAiApi.DEFAULT_EMBEDDING_MODEL).build(), RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode, ZhiPuAiEmbeddingOptions zhiPuAiEmbeddingOptions) {
        this(zhiPuAiApi, metadataMode, zhiPuAiEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode, ZhiPuAiEmbeddingOptions zhiPuAiEmbeddingOptions, RetryTemplate retryTemplate) {
        this(zhiPuAiApi, metadataMode, zhiPuAiEmbeddingOptions, retryTemplate, ObservationRegistry.NOOP);
    }

    public ZhiPuAiEmbeddingModel(ZhiPuAiApi zhiPuAiApi, MetadataMode metadataMode, ZhiPuAiEmbeddingOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)zhiPuAiApi, (String)"ZhiPuAiApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.zhiPuAiApi = zhiPuAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(embeddingRequest).provider(ZhiPuApiConstants.PROVIDER_NAME).build();
        ZhiPuAiApi.EmbeddingRequest<List<String>> zhipuEmbeddingRequest = this.zhipuEmbeddingRequest(embeddingRequest);
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity embeddingResponse = (ResponseEntity)this.retryTemplate.execute(ctx -> this.zhiPuAiApi.embeddings(zhipuEmbeddingRequest));
            if (embeddingResponse == null || embeddingResponse.getBody() == null || CollectionUtils.isEmpty(((ZhiPuAiApi.EmbeddingList)embeddingResponse.getBody()).data())) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            ZhiPuAiApi.Usage usage = ((ZhiPuAiApi.EmbeddingList)embeddingResponse.getBody()).usage();
            EmptyUsage usageResponse = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
            EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata(((ZhiPuAiApi.EmbeddingList)embeddingResponse.getBody()).model(), (Usage)usageResponse);
            List<Embedding> embeddings = ((ZhiPuAiApi.EmbeddingList)embeddingResponse.getBody()).data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            EmbeddingResponse response = new EmbeddingResponse(embeddings, metadata);
            observationContext.setResponse((Object)response);
            return response;
        });
    }

    private ZhiPuAiApi.EmbeddingRequest<List<String>> zhipuEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        return new ZhiPuAiApi.EmbeddingRequest<List<String>>(embeddingRequest.getInstructions(), embeddingRequest.getOptions().getModel(), embeddingRequest.getOptions().getDimensions());
    }

    private DefaultUsage getDefaultUsage(ZhiPuAiApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        ZhiPuAiEmbeddingOptions requestOptions;
        ZhiPuAiEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (ZhiPuAiEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, ZhiPuAiEmbeddingOptions.class);
        }
        if (!StringUtils.hasText((String)(requestOptions = (ZhiPuAiEmbeddingOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, ZhiPuAiEmbeddingOptions.class)).getModel())) {
            throw new IllegalArgumentException("model cannot be null or empty");
        }
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }
}

