/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.gemini.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.util.Assert;

public final class JsonSchemaConverter {
    private JsonSchemaConverter() {
    }

    public static ObjectNode fromJson(String jsonString) {
        try {
            return (ObjectNode)JsonParser.getObjectMapper().readTree(jsonString);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON: " + jsonString, e);
        }
    }

    public static ObjectNode convertToOpenApiSchema(ObjectNode jsonSchemaNode) {
        Assert.notNull((Object)jsonSchemaNode, (String)"JSON Schema node must not be null");
        try {
            ObjectNode openApiSchema = JsonSchemaConverter.convertSchema(jsonSchemaNode, JsonParser.getObjectMapper().getNodeFactory());
            if (!openApiSchema.has("openapi")) {
                openApiSchema.put("openapi", "3.0.0");
            }
            return openApiSchema;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert JSON Schema to OpenAPI format: " + e.getMessage(), e);
        }
    }

    private static void copyCommonProperties(ObjectNode source, ObjectNode target) {
        String[] commonProperties;
        Assert.notNull((Object)source, (String)"Source node must not be null");
        Assert.notNull((Object)target, (String)"Target node must not be null");
        for (String prop : commonProperties = new String[]{"type", "format", "description", "default", "maximum", "minimum", "maxLength", "minLength", "pattern", "enum", "multipleOf", "uniqueItems", "example", "deprecated", "readOnly", "writeOnly", "nullable", "discriminator", "xml", "externalDocs"}) {
            if (!source.has(prop)) continue;
            target.set(prop, source.get(prop));
        }
    }

    private static void handleJsonSchemaSpecifics(ObjectNode source, ObjectNode target) {
        String[] combiners;
        JsonNode items;
        Assert.notNull((Object)source, (String)"Source node must not be null");
        Assert.notNull((Object)target, (String)"Target node must not be null");
        if (source.has("properties")) {
            ObjectNode properties = target.putObject("properties");
            source.get("properties").fields().forEachRemaining(entry -> {
                if (entry.getValue() instanceof ObjectNode) {
                    properties.set((String)entry.getKey(), (JsonNode)JsonSchemaConverter.convertSchema((ObjectNode)entry.getValue(), JsonParser.getObjectMapper().getNodeFactory()));
                }
            });
        }
        if (source.has("required")) {
            target.set("required", source.get("required"));
        }
        if (source.has("additionalProperties")) {
            JsonNode additionalProps = source.get("additionalProperties");
            if (additionalProps.isBoolean()) {
                target.put("additionalProperties", additionalProps.asBoolean());
            } else if (additionalProps.isObject()) {
                target.set("additionalProperties", (JsonNode)JsonSchemaConverter.convertSchema((ObjectNode)additionalProps, JsonParser.getObjectMapper().getNodeFactory()));
            }
        }
        if (source.has("items") && (items = source.get("items")).isObject()) {
            target.set("items", (JsonNode)JsonSchemaConverter.convertSchema((ObjectNode)items, JsonParser.getObjectMapper().getNodeFactory()));
        }
        for (String combiner : combiners = new String[]{"allOf", "anyOf", "oneOf"}) {
            JsonNode combinerNode;
            if (!source.has(combiner) || !(combinerNode = source.get(combiner)).isArray()) continue;
            target.putArray(combiner).addAll((ArrayNode)combinerNode);
        }
    }

    private static ObjectNode convertSchema(ObjectNode source, JsonNodeFactory factory) {
        Assert.notNull((Object)source, (String)"Source node must not be null");
        Assert.notNull((Object)factory, (String)"JsonNodeFactory must not be null");
        ObjectNode converted = factory.objectNode();
        JsonSchemaConverter.copyCommonProperties(source, converted);
        JsonSchemaConverter.handleJsonSchemaSpecifics(source, converted);
        return converted;
    }
}

