/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public final class AudioPlayer {
    private AudioPlayer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static void main(String[] args) throws Exception {
        AudioPlayer.play(new BufferedInputStream(new FileInputStream(args[0])));
    }

    public static void play(byte[] data) {
        AudioPlayer.play(new BufferedInputStream(new ByteArrayInputStream(data)));
    }

    public static void play(InputStream data) {
        try (AudioInputStream audio = AudioSystem.getAudioInputStream(data);
             Clip clip = AudioSystem.getClip();){
            clip.open(audio);
            clip.start();
            while (!clip.isRunning()) {
                Thread.sleep(100L);
            }
            while (clip.isRunning()) {
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

