/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.test.vectorstore;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.filter.Filter;

public abstract class BaseVectorStoreTests {
    protected abstract void executeTest(Consumer<VectorStore> var1);

    protected Document createDocument(String country, Integer year) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("country", country);
        if (year != null) {
            metadata.put("year", year);
        }
        return new Document("The World is Big and Salvation Lurks Around the Corner", metadata);
    }

    protected List<Document> setupTestDocuments(VectorStore vectorStore) {
        Document doc1 = this.createDocument("BG", 2020);
        Document doc2 = this.createDocument("NL", null);
        Document doc3 = this.createDocument("BG", 2023);
        List<Document> documents = List.of(doc1, doc2, doc3);
        vectorStore.add(documents);
        return documents;
    }

    private String normalizeValue(Object value) {
        return value.toString().replaceAll("^\"|\"$", "").trim();
    }

    private void verifyDocumentsExist(VectorStore vectorStore, List<Document> documents) {
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollInterval(Duration.ofMillis(500L)).untilAsserted(() -> {
            List results = vectorStore.similaritySearch(SearchRequest.builder().query("The World").topK(documents.size()).similarityThresholdAll().build());
            Assertions.assertThat((List)results).hasSize(documents.size());
        });
    }

    private void verifyDocumentsDeleted(VectorStore vectorStore, List<String> deletedIds) {
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollInterval(Duration.ofMillis(500L)).untilAsserted(() -> {
            List results = vectorStore.similaritySearch(SearchRequest.builder().query("The World").topK(10).similarityThresholdAll().build());
            List foundIds = results.stream().map(Document::getId).collect(Collectors.toList());
            Assertions.assertThat(foundIds).doesNotContainAnyElementsOf((Iterable)deletedIds);
        });
    }

    @Test
    protected void deleteById() {
        this.executeTest(vectorStore -> {
            List<Document> documents = this.setupTestDocuments((VectorStore)vectorStore);
            this.verifyDocumentsExist((VectorStore)vectorStore, documents);
            List<String> idsToDelete = List.of(documents.get(0).getId(), documents.get(1).getId());
            vectorStore.delete(idsToDelete);
            this.verifyDocumentsDeleted((VectorStore)vectorStore, idsToDelete);
            List results = vectorStore.similaritySearch(SearchRequest.builder().query("The World").topK(5).similarityThresholdAll().build());
            Assertions.assertThat((List)results).hasSize(1);
            Assertions.assertThat((String)((Document)results.get(0)).getId()).isEqualTo(documents.get(2).getId());
            Map metadata = ((Document)results.get(0)).getMetadata();
            Assertions.assertThat((String)this.normalizeValue(metadata.get("country"))).isEqualTo("BG");
            Assertions.assertThat((String)this.normalizeValue(metadata.get("year"))).containsAnyOf(new CharSequence[]{"2023", "2023.0"});
            vectorStore.delete(List.of(documents.get(2).getId()));
        });
    }

    @Test
    protected void deleteWithStringFilterExpression() {
        this.executeTest(vectorStore -> {
            List<Document> documents = this.setupTestDocuments((VectorStore)vectorStore);
            this.verifyDocumentsExist((VectorStore)vectorStore, documents);
            List<String> bgDocIds = documents.stream().filter(d -> "BG".equals(d.getMetadata().get("country"))).map(Document::getId).collect(Collectors.toList());
            vectorStore.delete("country == 'BG'");
            this.verifyDocumentsDeleted((VectorStore)vectorStore, bgDocIds);
            List results = vectorStore.similaritySearch(SearchRequest.builder().query("The World").topK(5).similarityThresholdAll().build());
            Assertions.assertThat((List)results).hasSize(1);
            Assertions.assertThat((String)this.normalizeValue(((Document)results.get(0)).getMetadata().get("country"))).isEqualTo("NL");
            vectorStore.delete(List.of(documents.get(1).getId()));
        });
    }

    @Test
    protected void deleteByFilter() {
        this.executeTest(vectorStore -> {
            List<Document> documents = this.setupTestDocuments((VectorStore)vectorStore);
            this.verifyDocumentsExist((VectorStore)vectorStore, documents);
            List<String> bgDocIds = documents.stream().filter(d -> "BG".equals(d.getMetadata().get("country"))).map(Document::getId).collect(Collectors.toList());
            Filter.Expression filterExpression = new Filter.Expression(Filter.ExpressionType.EQ, (Filter.Operand)new Filter.Key("country"), (Filter.Operand)new Filter.Value((Object)"BG"));
            vectorStore.delete(filterExpression);
            this.verifyDocumentsDeleted((VectorStore)vectorStore, bgDocIds);
            List results = vectorStore.similaritySearch(SearchRequest.builder().query("The World").topK(5).similarityThresholdAll().build());
            Assertions.assertThat((List)results).hasSize(1);
            Assertions.assertThat((String)this.normalizeValue(((Document)results.get(0)).getMetadata().get("country"))).isEqualTo("NL");
            vectorStore.delete(List.of(documents.get(1).getId()));
        });
    }
}

